#include "StdAfx.h"
#include "DataBaseManager.h"


//////////////////////////////////////////////////////////////////////////
CDatabaseManager::CDatabaseManager(const CString& host, const CString& db, const CString& user, const CString& pwd)
{
	try
	{
		m_db.OpenEx("Driver={MySQL ODBC 3.51 Driver};\
				     Server="+host+";Database="+db+";\
				     User="+user+";Password="+pwd+";", CDatabase::noOdbcDialog);
	}
	catch(CDBException* pEX)
	{
		AfxMessageBox( pEX->m_strError );
		pEX->Delete();
	}
}


//////////////////////////////////////////////////////////////////////////
CDatabaseManager::~CDatabaseManager(void)
{
	if (IsOpen())
		m_db.Close();
}


//////////////////////////////////////////////////////////////////////////
bool CDatabaseManager::IsOpen()
{
	return m_db.IsOpen()==TRUE;
}


//////////////////////////////////////////////////////////////////////////
bool CDatabaseManager::Execute(const CString& operation, bool silent)
{
	try 
	{
		m_db.ExecuteSQL(operation);
	}
	catch(CDBException* pEX)
	{
		if (!silent)
			AfxMessageBox( pEX->m_strError );
		pEX->Delete();
		return false;
	}
	return true;
}


//////////////////////////////////////////////////////////////////////////
CRecordset* CDatabaseManager::Query(const CString &query)
{
	CRecordset* pRs = new CRecordset( &m_db );
	pRs->Open( CRecordset::forwardOnly, query );
	return pRs;
}
