#include "StdAfx.h"
#include "Helper.h"


//////////////////////////////////////////////////////////////////////////
char CHelper::DecToHex(int dec)
{
	return dec<10 ? ((char)(dec+'0')) : ((char)(dec-10+'A'));
}


//////////////////////////////////////////////////////////////////////////
CString CHelper::ToHex(DWORD nr, int digits)
{
	DWORD div = 1;
	CString hex;
	for (int i=0;i<digits;i++)
	{
		hex = CString(DecToHex((nr/div)%16)) + hex;
		div *= 16;
	}

	return hex;
}


//////////////////////////////////////////////////////////////////////////
CString CHelper::ConvertToString(DWORD val)
{
	char buf[14];
	sprintf_s((char*)&buf,13,"%d",val);
	return CString(buf);
}


//////////////////////////////////////////////////////////////////////////
DWORD CHelper::ConvertToInt(const CString &val)
{
	DWORD out;
	sscanf_s(val, "%d", &out);
	return out;
}


//////////////////////////////////////////////////////////////////////////
CString CHelper::GetGUID()
{
	GUID guid;
	CoCreateGuid(&guid);

	CString data;
	for (int i=0;i<4;i++) data += ToHex(((char*)&guid.Data1)[i], 2);
	data += "-";
	for (int i=0;i<4;i++) data += ToHex(((char*)&guid.Data2)[i], 2);
	data += "-";
	for (int i=0;i<4;i++) data += ToHex(((char*)&guid.Data3)[i], 2);
	data += "-";
	for (int i=0;i<4;i++) data += ToHex(((char*)&guid.Data4)[i], 2);

	return data;
}


//////////////////////////////////////////////////////////////////////////
CString CHelper::ReadLine(CFile &file)
{
	char buffer[1024];
	int pos = 0;

	while (pos<1023)
	{
		if(file.Read(&buffer[pos],1)==0)
			break;

		if (buffer[pos]==10 || buffer[pos]==13)
		{
			if (pos==0)
				continue;
			break;
		}
		pos++;
	}

	buffer[pos] = 0;
	return CString(buffer);
}
