#include "StdAfx.h"
#include "UniKeyManager.h"


#include "Helper.h"


//////////////////////////////////////////////////////////////////////////
CUniKeyManager::CUniKeyManager()
{
	ClearContext();
}


//////////////////////////////////////////////////////////////////////////
void CUniKeyManager::ClearContext()
{
	memset(&m_sDynamicData, 0, sizeof(SDynamicData));
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::Connect(WORD p1, WORD p2, WORD p3, WORD p4)
{
	bool success = true;

	m_p1 = p1;
	m_p2 = p2;
	m_p3 = p3;
	m_p4 = p4;
	success &= CallKey(UNIKEY_FIND);
	if (!success)
		return false;

	m_dwHID = m_lp1;
	success &= CallKey(UNIKEY_LOGON);

	return success;
}


//////////////////////////////////////////////////////////////////////////
void CUniKeyManager::Disconnect()
{
	CallKey(UNIKEY_LOGOFF);
}


//////////////////////////////////////////////////////////////////////////
SDynamicData& CUniKeyManager::GetDynamicData()
{
	return m_sDynamicData;
}


//////////////////////////////////////////////////////////////////////////
CString CUniKeyManager::FormatTime(const CString &format, const time_t& rawTime)
{
	if (rawTime==0)
		return "[Not set]";

	tm *timeInfo = localtime( &rawTime );
	CString formatCpy = format;
	CString result;

	for (int i=0;i<formatCpy.GetLength();i++)
	{
		char ch = formatCpy.GetBuffer()[i];

		if (ch=='Y')
		{
			int year = 1900+timeInfo->tm_year;
			char buf[5] = {year/1000+'0', (year/100)%10+'0', (year/10)%10+'0', year%10+'0', 0};
			result += (char*)&buf;
		}
		else if (ch=='m')
		{
			int mon = 1+timeInfo->tm_mon;
			char buf[3] = {mon/10+'0', mon%10+'0', 0};
			result += (char*)&buf;
		}
		else if (ch=='d')
		{
			char buf[3] = {timeInfo->tm_mday/10+'0', timeInfo->tm_mday%10+'0', 0};
			result += (char*)&buf;
		}
		else if (ch=='H')
		{
			char buf[3] = {timeInfo->tm_hour/10+'0', timeInfo->tm_hour%10+'0', 0};
			result += (char*)&buf;
		}
		else if (ch=='i')
		{
			char buf[3] = {timeInfo->tm_min/10+'0', timeInfo->tm_min%10+'0', 0};
			result += (char*)&buf;
		}
		else if (ch=='s')
		{
			char buf[3] = {timeInfo->tm_sec/10+'0', timeInfo->tm_sec%10+'0', 0};
			result += (char*)&buf;
		}
		else
			result += ch;
	}

	return result;
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::CallKey(WORD function)
{
	m_dwLastError = UniKey(function, &m_wHandle, &m_lp1, &m_lp2, &m_p1, &m_p2, &m_p3, &m_p4, (BYTE*)m_pBuffer);
	return m_dwLastError==0;
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::RefreshKey()
{
	bool success = true;

	ClearContext();

	m_lp1 = 1;
	success &= CallKey(UNIKEY_GENERATE_KEY);

	srand(GetCurrentTime());

	for (int i=0;i<UNIKEY_BUFFER_SIZE;i++)
		m_pBuffer[i] = rand();

	m_p1 = 0;
	m_p2 = UNIKEY_BUFFER_SIZE;
	success &= CallKey(UNIKEY_WRITE_MEMORY);

	return success;
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::StoreData(const char* source)
{
	bool success = true;
	int dynLen = sizeof(SDynamicData);
	int encDynLen = (dynLen/8+1)*8;

	DWORD len = 0;
	DWORD encLen = 0;
	if (source!=NULL)
	{
		len = (DWORD)strlen(source)+1;
		encLen = (len/8+1)*8;
		m_sDynamicData.privateDataLength = len;
	}

	m_sDynamicData.header = 'DATA';
	m_sDynamicData.headerVersion = HIWORD(1)+LOWORD(0);

	memcpy(m_pBuffer, &m_sDynamicData, dynLen);
	memcpy(&m_pBuffer[encDynLen], source, len);

	m_lp1 = encDynLen + encLen;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_ENCRYPT);

	m_p1 = 0;
	m_p2 = encDynLen + encLen;
	success &= CallKey(UNIKEY_WRITE_MEMORY);

	return success;

	/*bool success = true;
	DWORD len = (DWORD)strlen(source)+1;
	DWORD header[2];
	header[0] = 'DATA';
	header[1] = len;

	memcpy(m_pBuffer, header, 8);
	memcpy(&m_pBuffer[8], source, len);

	m_lp1 = 8 + (len/8+1)*8;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_ENCRYPT);

	m_p1 = 0;
	m_p2 = 8 + (len/8+1)*8;
	success &= CallKey(UNIKEY_WRITE_MEMORY);

	return success;*/
}


//////////////////////////////////////////////////////////////////////////
char* CUniKeyManager::ReadData()
{
	bool success = true;
	int dynLen = sizeof(SDynamicData);
	int decDynLen = (dynLen/8+1)*8;

	m_p1 = 0;
	m_p2 = decDynLen;
	success &= CallKey(UNIKEY_READ_MEMORY);

	m_lp1 = decDynLen;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_DECRYPT);
	memcpy(&m_sDynamicData, m_pBuffer, dynLen);

	if (!success || m_sDynamicData.header!='DATA' || m_sDynamicData.headerVersion<(HIWORD(1)+LOWORD(0)))
		return NULL;

	DWORD len = m_sDynamicData.privateDataLength;
	DWORD decLen = len==0 ? 0 : (len/8+1)*8;

	m_p1 = decDynLen;
	m_p2 = decLen;
	success &= CallKey(UNIKEY_READ_MEMORY);

	m_lp1 = decLen;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_DECRYPT);

	return success ? m_pBuffer : NULL;


	/*bool success = true;
	DWORD header[2];

	m_p1 = 0;
	m_p2 = 8;
	success &= CallKey(UNIKEY_READ_MEMORY);

	m_lp1 = 8;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_DECRYPT);
	memcpy(header, m_pBuffer, 8);

	if (header[0]!='DATA' || !success)
		return NULL;

	m_p1 = 8;
	m_p2 = (header[1]/8+1)*8;
	success &= CallKey(UNIKEY_READ_MEMORY);

	m_lp1 = (header[1]/8+1)*8;
	m_lp2 = 1;
	success &= CallKey(UNIKEY_DECRYPT);

	return success ? m_pBuffer : NULL;*/
}


//////////////////////////////////////////////////////////////////////////
char* CUniKeyManager::MD5(const char* data)
{
	bool success = true;

	m_lp1 = strlen(data);
	m_lp2 = 0;
	memcpy(m_pBuffer, data, strlen(data));
	success &= CallKey(UNIKEY_MD5);

	m_pBuffer[32] = 0;
	return success ? m_pBuffer : NULL;
}


//////////////////////////////////////////////////////////////////////////
DWORD CUniKeyManager::GetHID()
{
	return m_dwHID;
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::RequestConnectCode(DWORD seed)
{
	bool success = true;

	m_lp1 = seed;
	success &= CallKey(UNIKEY_SET_NEW_PASSWORD);

	CString data = 
		"Pwd1: "+CHelper::ConvertToString(m_p1)+"\r\n"+
		"Pwd2: "+CHelper::ConvertToString(m_p2)+"\r\n"+
		"Pwd3: "+CHelper::ConvertToString(m_p3)+"\r\n"+
		"Pwd4: "+CHelper::ConvertToString(m_p4)+"\r\n";

	// Write password to file, to ensure further accessibility of dongle
	CFile f;
	f.Open("DonglePassword_Seed_"+CHelper::ConvertToString(seed)+".txt", CFile::modeCreate|CFile::modeWrite);
	f.Write(data.GetBuffer(),data.GetLength());
	f.Close();
	
	return success;
}


//////////////////////////////////////////////////////////////////////////
bool CUniKeyManager::CheckTimeTamper()
{
	time_t now = time(0);
	if (m_sDynamicData.lastAccessDate>0 && now<m_sDynamicData.lastAccessDate)
	{
		m_sDynamicData.lastTimeTamper = now;
		StoreData(NULL);
		return true;
	}

	m_sDynamicData.lastAccessDate = time(0);
	StoreData(NULL);
	return false;
}
