#pragma once


#include "UniKeyLib/UniKey.h"


// UniKey properties
#define UNIKEY_BUFFER_SIZE			4096


struct SDynamicData
{
	DWORD		header;
	DWORD		headerVersion;

	DWORD		privateDataLength;
	time_t		lastAccessDate;
	time_t		lastServerConnect;
	time_t		lastTimeTamper;

	DWORD		reserved[8];
};


class CUniKeyManager
{
public:
	CUniKeyManager();

	// connects class to the first dongle found
	bool					Connect(WORD p1, WORD p2, WORD p3, WORD p4);

	void					Disconnect();

	// generate a new encryption/decryption key, clear dongle with random data
	bool					RefreshKey();

	// writes data to dongle, encrypting it with encryption key
	bool					StoreData(const char* source);

	// decrypts and returns data stored on dongle
	char* 					ReadData();

	char*					MD5(const char* data);

	// ATTENTION: This Function can only be called twice per dongle!
	bool					RequestConnectCode(DWORD seed);

	DWORD					GetHID();
	SDynamicData&			GetDynamicData();

	bool					CheckTimeTamper();

	CString					FormatTime(const CString &format, const time_t& rawTime);

private:
	bool					CallKey(WORD function);
	void					ClearContext();

private:
	SDynamicData			m_sDynamicData;

	DWORD					m_dwLastError;
	WORD					m_wHandle, m_p1, m_p2, m_p3, m_p4;
	DWORD					m_dwHID;
	char					m_pBuffer[UNIKEY_BUFFER_SIZE];
	DWORD					m_lp1, m_lp2;
};
