#pragma once


#include "DatabaseManager.h"
#include "UniKeyManager.h"


#include <winsock2.h>
#include <string>


struct SUniKeyManagerConfig
{
	CString sServerUrl;
};


class CUniKeyRegistererDlg : public CDialog
{
public:
	CUniKeyRegistererDlg(CWnd* pParent = NULL);
	enum { IDD = IDD_UNIKEYREGISTERER_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:
	HICON m_hIcon;
	CStatic m_imgConnectState;
	CStatic m_lStateInfo;
	CStatic m_lHID;
	CStatic m_lSID;
	CStatic m_lLastAccess;
	CStatic m_lLastTimeTamper;
	CStatic m_lLastConnectTime;
	CButton m_bOk;
	CButton m_bReset;

	/*CDatabaseManager* m_pDbm;*/
	SOCKET					m_ce2ServerSocket;
	SUniKeyManagerConfig m_cfg;

	bool m_bQuitDonglecheckThread;
	bool m_bResetClicked;

public:
	void		UpdateConnectionStateView();
	void		StartDonglecheckThread();

	static unsigned long DonglecheckThreadEntry(LPVOID data);

	bool		GetGUIDFromDB(DWORD hid, CString& res);
	bool		RegisterDongleToDB(DWORD hid, CString& sid);
	CString		PrepareDongleForDelivery(CUniKeyManager& ukm);
	bool		DongleIsInitialized(CUniKeyManager& ukm);

private:
	CString		FormatTime(const CString &format, const time_t& rawTime);
	void		ClearDongleStateUI();
	int			ConnectToCE2Server();
	std::string		GetValue(const std::string& source, const std::string& key);

public:
	afx_msg void OnButtonClicked();
	afx_msg void OnOkClicked();
};
