////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   ixml.h
//  Version:     v1.00
//  Created:     16/7/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __ixml_h__
#define __ixml_h__

#if _MSC_VER > 1000
#pragma once
#endif

#pragma warning(3: 4263)
#pragma warning(3: 4264)

//#include <vector>
//#include <set>
#include <string>

using std::string;

/**

	This is wrapper arround expat library to provide DOM type of access for xml.
	Do not use IXmlNode class directly instead always use XmlNodeRef wrapper that
	takes care of memory managment issues.

	Usage Example:
	-------------------------------------------------------
	void testXml()
	{
		XmlParser xml;
		XmlNodeRef root = xml.parse( "test.xml" );

		if (root) {
			for (int i = 0; i < root->getChildCount(); i++) {
				XmlNodeRef child = root->getChild(i);
				if (child->isTag("world")) {
					if (child->getAttr("name") == "blah") {
					}
				}
			}
		}
	};
*/


class IXmlNode;

/**
 ******************************************************************************
 * XmlNodeRef, wrapper class implementing reference counting for IXmlNode.
 ******************************************************************************
 */
/*
class XmlNodeRef {
private:
  IXmlNode* p;
public:
  XmlNodeRef() : p(NULL) {}
	XmlNodeRef( int Null ) : p(NULL) {}
  XmlNodeRef( IXmlNode* p_ );
  XmlNodeRef( const IXmlNode const&p_ );
	//explicit XmlNodeRef( const char *tag,IXmlNode *node );
  ~XmlNodeRef();
	
  operator IXmlNode*() const { return p; }
  operator const IXmlNode*() const { return p; }
  IXmlNode& operator*() const { return *p; }
  IXmlNode* operator->(void) const { return p; }
  
  XmlNodeRef&  operator=( IXmlNode* newp );
	XmlNodeRef&  operator=( const IXmlNode const&newp );
	
  operator bool() const { return p != NULL; };
	bool operator !() const { return p == NULL; };
	
 	// Misc compare functions.
  bool  operator == ( const IXmlNode* p2 ) const { return p == p2; };
	bool  operator == ( IXmlNode* p2 ) const { return p == p2; };
  bool  operator != ( const IXmlNode* p2 ) const { return p != p2; };
  bool  operator != ( IXmlNode* p2 ) const { return p != p2; };
  bool  operator <  ( const IXmlNode* p2 ) const { return p < p2; };
  bool  operator >  ( const IXmlNode* p2 ) const { return p > p2; };

	bool  operator == ( const IXmlNode const&n ) const { return p == n.p; };
  bool  operator != ( const IXmlNode const&n ) const { return p != n.p; };
  bool  operator <  ( const IXmlNode const&n ) const { return p < n.p; };
  bool  operator >  ( const IXmlNode const&n ) const { return p > n.p; };
	
	friend bool operator == ( const IXmlNode const&p1,int null );
  friend bool operator != ( const IXmlNode const&p1,int null );
	friend bool operator == ( int null,const IXmlNode const&p1 );
  friend bool operator != ( int null,const IXmlNode const&p1 );
};
*/

/**
 ******************************************************************************
 * IXmlNode class
 * Never use IXmlNode directly instead use reference counted XmlNodeRef.
 ******************************************************************************
 */

/*
class IXmlNode {
public:
	virtual ~IXmlNode() {};

	//! Create new XML node.
	virtual IXmlNode* createNode( const char *tag ) = 0;

	//////////////////////////////////////////////////////////////////////////
	//! Reference counting.
	virtual void AddRef() = 0;
	//! When ref count reach zero XML node dies.
	virtual void Release() = 0;

	//////////////////////////////////////////////////////////////////////////
	//! Get XML node tag.
	virtual XmlString const& getTag() const = 0;
	virtual void	setTag( const char *tag ) = 0;

	//! Return true if givven tag equal to node tag.
	virtual bool isTag( const char *tag ) const = 0;

	//! Get XML Node attributes.
	virtual int getNumAttributes() const = 0;
	//! Return attribute key and value by attribute index.
	virtual bool getAttributeByIndex( int index, XmlString *key, XmlString *value ) = 0;
	
	//! Copy attributes to this node from givven node.
	virtual void copyAttributes( IXmlNode const& fromNode ) = 0;

	//! Get XML Node attribute for specified key.
	virtual XmlString const& getAttr( const char *key ) const = 0;
	//! Check if attributes with specified key exist.
	virtual bool haveAttr( const char *key ) const = 0;
	
	//! Adds new child node.
	virtual void addChild( IXmlNode& node, int pos = -1 ) = 0;

	//! Creates new xml node and add it to childs list.
	virtual IXmlNode* newChild( const char *tagName ) = 0;

	//! Remove child node.
	virtual void removeChild( IXmlNode& node ) = 0;

	//! Remove all child nodes.
	virtual void removeAllChilds() = 0;

	//! Get number of child XML nodes.
	virtual int	getChildCount() const = 0;
	
	//! Get XML Node child nodes.
	virtual IXmlNode* getChild( int i ) const = 0;

	//! Find node with specified tag.
	virtual IXmlNode* findChild( const char *tag ) const = 0;
	virtual void deleteChild( const char *tag ) = 0;
	virtual void deleteChildAt( int nIndex ) = 0;

	//! Get parent XML node.
	virtual IXmlNode* getParent() const = 0;

	//! Returns content of this node.
	virtual XmlString const& getContent() const = 0;
	virtual void setContent( const char *str ) = 0;
	virtual void addContent( const char *str ) = 0;

	//! Deep clone of this and all child xml nodes.
	virtual IXmlNode* clone() = 0;

	//! Returns line number for XML tag.
	virtual int getLine() const = 0;
	//! Set line number in xml.
	virtual void setLine( int line ) = 0;

	//! Returns XML of this node and sub nodes.
	virtual XmlString getXML( int level=0 ) = 0;
	virtual bool saveToFile( const char *fileName ) = 0;

	//! Set new XML Node attribute (or override attribute with same key).
	virtual void setAttr( const char* key, const char* value ) = 0;
	virtual void setAttr( const char* key, int value ) = 0;
	virtual void setAttr( const char* key, unsigned int value ) = 0;
	virtual void setAttr( const char* key, float value ) = 0;
	//////////////////////////////////////////////////////////////////////////
	// Inline Helpers.
	void setAttr( const char* key, unsigned long value ) { setAttr( key,(unsigned int)value ); };
	void setAttr( const char* key, long value ) { setAttr( key,(int)value ); };
	//////////////////////////////////////////////////////////////////////////
	

	//! Delete attrbute.
	virtual void delAttr( const char* key ) = 0;
	//! Remove all node attributes.
	virtual void removeAllAttributes() = 0;

	//! Get attribute value of node.
	virtual bool getAttr( const char *key, int &value ) const = 0;
	virtual bool getAttr( const char *key, unsigned int &value ) const = 0;
	virtual bool getAttr( const char *key, float &value ) const = 0;
	virtual bool getAttr( const char *key, bool &value ) const = 0;
	virtual bool getAttr( const char *key, XmlString &value ) const = 0;
	//////////////////////////////////////////////////////////////////////////
	// Inline Helpers.
	bool getAttr( const char *key, long &value ) const { int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
	bool getAttr( const char *key, unsigned long &value ) const { unsigned int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
	bool getAttr( const char *key, unsigned short &value ) const { unsigned int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
	bool getAttr( const char *key, unsigned char &value ) const { unsigned int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
	bool getAttr( const char *key, short &value ) const { int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
	bool getAttr( const char *key, char &value ) const { int v; if (getAttr(key,v)) { value = v; return true; } else return false; }
};
*/

/*
///////////////////////////////////////////////////////////////////////////////
// Inline Implementation of XmlNodeRef
inline XmlNodeRef::XmlNodeRef( const char *tag,IXmlNode *node )
{
	if (node)
		p = node->createNode( tag );
	else
		p = new IXmlNode( tag );
	p->AddRef();
}
*/

/*
//////////////////////////////////////////////////////////////////////////
inline XmlNodeRef::XmlNodeRef( IXmlNode* p_ ) : p(p_)
{
	if (p) p->AddRef();
}

inline XmlNodeRef::XmlNodeRef( const IXmlNode const&p_ ) : p(p_.p)
{
	if (p) p->AddRef();
}

inline XmlNodeRef::~XmlNodeRef()
{
	if (p) p->Release();
}

inline XmlNodeRef&  XmlNodeRef::operator=( IXmlNode* newp )
{
	if (newp) newp->AddRef();
	if (p) p->Release();
	p = newp;
	return *this;
}

inline XmlNodeRef&  XmlNodeRef::operator=( const IXmlNode const&newp )
{
	if (newp.p) newp.p->AddRef();
	if (p) p->Release();
	p = newp.p;
	return *this;
}

inline bool operator == ( const IXmlNode const&p1,int null )	{
	return p1.p == 0;
}

inline bool operator != ( const IXmlNode const&p1,int null )	{
	return p1.p != 0;
}

inline bool operator == ( int null,const IXmlNode const&p1 )	{
	return p1.p == 0;
}

inline bool operator != ( int null,const IXmlNode const&p1 )	{
	return p1.p != 0;
}
*/

#endif // __ixml_h__
