//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 1999-2003 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2003 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

#ifndef OPENGL13_SHADERS_H
#define OPENGL13_SHADERS_H

#ifdef _WIN32
#include <windows.h>
#endif

#include <assert.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <gl/glext.h>
#include <xsi_rtshaders.h>

#ifdef linux
#undef GL_VERSION_1_2
#undef __glext_h_
#undef GL_ARB_multitexture

#include <malloc.h>
#ifndef BYTE
#define BYTE unsigned char
#endif
#ifndef DWORD
#define DWORD ULONG
#endif
#endif

#define RED_CHANNEL		0
#define GREEN_CHANNEL	1
#define BLUE_CHANNEL	2
#define ALPHA_CHANNEL 3
#define ALL_CHANNEL		4

//****************************************************************************************
// Structures
//****************************************************************************************

//****************************************************************************************
// Function prototypes
//****************************************************************************************

//****************************************************************************************
// These functions should not have any name mangling
//****************************************************************************************
#ifdef __cplusplus
extern "C"
{
RTSHADER_API ULONG RTS_GetVersion();

RTSHADER_API bool CrytekVertexColor_Init	
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	void							**io_pShaderInstanceData		//! The shader instance data
);


RTSHADER_API bool CrytekVertexColor_Execute		
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_TriangulatedGeometry	*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData		//! The shader instance data
);

RTSHADER_API bool CrytekVertexColor_GetRequirements		
(
	XSI_RTS_SystemParams			*in_pSysParams,					//! The system parameters
	void							*in_pParams,					//! The property page parameters
	XSI_RTS_TriangulatedGeometry	*in_pGeom,						//! The geometry information
	void							**io_pShaderInstanceData,		//! The shader instance data
	ULONG					in_lFlag,						//! The flag to check
	ULONG					*out_pValue						//! The returned value
);

}


#endif // __cplusplus

#endif // OPENGL_SHADERS_H
