//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file FTKUtil.h
/*!
	definition file for the FTK utility functions
*/

#ifndef FTKUTIL_H
#define FTKUTIL_H

#include <VariantParameter.h>
#include <XSIShader.h>
#include <XSIMaterial.h>
#include <ShaderConnectionPoint.h>
#include <XSIImage.h>
#include <Model.h>
#include <ShaderInstanceData.h>
#include <Shape.h>
#include <Shape_35.h>
#include <Mesh.h>
#include <UVCoordArray.h>
#include <FCurve.h>
#include <xsi_projectitem.h>
#include <CoordinateSystem.h>

#define EPSILON 0.000001f

using namespace XSI;

class CAnimationPlotter;

extern CSLVariantParameter			*FTKUSetShaderParameterValue(CSLXSIShader *in_pShader, char *in_pName, float in_fValue);
extern CSLVariantParameter			*FTKUSetShaderParameterValue(CSLXSIShader *in_pShader, char *in_pName, LONG in_lValue);
extern CSLVariantParameter			*FTKUSetShaderParameterValue(CSLXSIShader *in_pShader, char *in_pName, bool in_bValue);
extern CSLVariantParameter			*FTKUSetShaderParameterValue(CSLXSIShader *in_pShader, char *in_pName, char *in_pValue);

extern CSLVariantParameter			*FTKUSetParameterValue(CSLVariantParameter *in_pParameter, float in_fValue);
extern CSLVariantParameter			*FTKUSetParameterValue(CSLVariantParameter *in_pParameter, LONG in_lValue);
extern CSLVariantParameter			*FTKUSetParameterValue(CSLVariantParameter *in_pParameter, bool in_bValue);
extern CSLVariantParameter			*FTKUSetParameterValue(CSLVariantParameter *in_pParameter, char *in_pValue);

extern CSLConnectionPoint 			*FTKUConnectShader(CSLXSIShader *in_pSource, CSLXSIMaterial *in_pDestination, char *in_pConnection);
extern CSLShaderConnectionPoint 	*FTKUConnectShader(CSLXSIShader *in_pSource, CSLXSIShader *in_pDestination, char *in_pConnection);
extern CSLShaderConnectionPoint 	*FTKUConnectImage(CSLImage *in_pSource, CSLXSIShader *in_pDestination, char *in_pConnection);
extern void							FTKUGetUsedTexCoord(CSLModel *in_pModel, CSLXSIMaterial *in_pMaterial, int *out_pNbTexCoord, int **out_pTexCoordIndices, bool **out_pTexCoordRepeated);
extern void							FTKUSetShaderTextureSpaceID(CSLModel *in_pModel, CSLXSIMaterial *in_pMaterial, char *in_pTextureProjectionName, int in_nShaderIndex);
extern CSLShaderConnectionPoint		*FTKUGetConnection(CSLXSIShader *in_pShader, char *in_pName);
extern CSLXSIShader*				FTKUGetPreviousRTS(CSLXSIShader* in_pShader);
extern void							FTKUParameterAnimationFromXSI(CSLTemplate* in_pFTKTemplate,	const CRefArray &in_XSIParameterList,	CSLFCurve::EFCurveType in_eFCurveType, CAnimationPlotter *in_pAnimationPlotter, const CString &in_ParamName);
extern void							FTKUParameterAnimationFromXSI(CSLTemplate* in_pFTKTemplate,	CSLFCurve::EFCurveType in_eFCurveType, const Parameter &in_Parameter, CAnimationPlotter *in_pAnimationPlotter, const CString &in_ParamName = CString());
extern void							FTKUProxyParameterAnimationFromXSI(CSLTemplate* in_pFTKTemplate,	CSLFCurve::EFCurveType in_eFCurveType, const Parameter &in_ProxyParameter, const Parameter &in_Parameter, CAnimationPlotter *in_pAnimationPlotter, const CString &in_ParamName = CString());
extern void							FTKUFCurveFromXSI(CSLTemplate* in_pFTKTemplate,	CSLFCurve::EFCurveType in_eFCurveType, const FCurve &in_FCurve, CAnimationPlotter *in_pAnimationPlotter, const CString &in_ParamName = CString());
extern void							FTKUParameterAnimationToXSI(CSLFCurve* in_pFTKFCurve, const CParameterRefArray &in_XSIParameters);
extern void							FTKUParameterAnimationToXSI(CSLFCurve* in_pFTKFCurve, const CParameterRefArray &in_XSIParameters, CString in_ParamName);
extern void							FTKUFCurveToXSI(CSLBaseFCurve* in_pFTKFCurve, FCurve &in_XSIFCurve);

extern bool							IsZUp(CSLCoordinateSystem *in_pCoordinateSystem);
extern void							FTKUPathAbsoluteToRelative(char* in_pAbsolutePath, char* in_pFileName, CSIBCString &out_RelativePath);
extern void							FTKUPathRelativeToAbsolute(char* in_pRelativePath, char* in_pFileName, CSIBCString &out_AbsolutePath);

#endif // FTKUTIL_H
