//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_dotXSI_IO.h   
    Definition file for the dotXSI IO classes
*/

#ifndef CNV_COLLADA_IO_H_
#define CNV_COLLADA_IO_H_

#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"

//! Class CCOLLADA_Write
/*!
    This is the class that implements writing the FTK content as a dotXSI file
*/
class CCOLLADA_Write : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CCOLLADA_Write();

//! Default destructor
	virtual ~CCOLLADA_Write();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif CNV_COLLADA_IO_H_