//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_camera_anim.h
/*!
	definition file for camera animation related classes
*/

#ifndef CNV_CAMERA_ANIM_H
#define CNV_CAMERA_ANIM_H


#include "cnv_hierarchytraversal.h"
#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"
#include "cnv_plottedanimation.h"

//! class CCameraAnimationFromXSI
/*!
    class that implements a callback to get the camera animation from XSI
*/
class CCameraAnimationFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CCameraAnimationFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CCameraAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

//! Get the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\return CAnimationPlotter* the instance of animation plotter
*/
	CAnimationPlotter *GetAnimationPlotter();

	
//! Set the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\param in_pAnimationPlotter the instance of animation plotter
	\return void
*/
	void SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter);

private:

	CAnimationPlotter	*m_pAnimationPlotter;

};

//! class CCameraAnimationToXSI
/*!
    class that implements a callback to set the camera animation in XSI
*/
class CCameraAnimationToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CCameraAnimationToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CCameraAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSICameraAnimationFromXSI
/*!
    class that implements a callback to get the camera animation from XSI
*/
class CXSICameraAnimationFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSICameraAnimationFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSICameraAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

//! Get the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\return CAnimationPlotter* the instance of animation plotter
*/
	CAnimationPlotter *GetAnimationPlotter();

	
//! Set the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\param in_pAnimationPlotter the instance of animation plotter
	\return void
*/
	void SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter);

private:

	CAnimationPlotter	*m_pAnimationPlotter;

};

//! class CXSICameraAnimationToXSI
/*!
    class that implements a callback to set the camera animation in XSI
*/
class CXSICameraAnimationToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSICameraAnimationToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSICameraAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif // CNV_CAMERA_ANIM_H
