//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_custompset.h
/*!
	definitition file for custom pset classes
*/

#ifndef CNV_CUSTOMPSET_H
#define CNV_CUSTOMPSET_H

#include "cnv_hierarchytraversal.h"
#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"

//! class CCustomPSetFromXSI
/*!
    class to get custom psets from XSI
*/
class CCustomPSetFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CCustomPSetFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CCustomPSetFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CCustomPSetToXSI
/*!
    class to set custom psets in XSI
*/
class CCustomPSetToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CCustomPSetToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CCustomPSetToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};





#endif // CNV_CUSTOMPSET_H
