//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_environment.h   
    Definition file for the dotXSI environment classes
*/

#ifndef CNV_ENVIRONMENT_H
#define CNV_CENVIRONMENT_H

#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"

//! Class CEnvironmentFromXSI
/*!
    This is the class that implements getting the environment (ambience) from XSI into dotXSI
*/
class CEnvironmentFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CEnvironmentFromXSI();

//! Default destructor
	virtual ~CEnvironmentFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


//! Class CEnvironmentToXSI
/*!
    This is the class that implements setting the environment (ambience) from dotXSI into XSI
*/
class CEnvironmentToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CEnvironmentToXSI();

//! Default destructor
	virtual ~CEnvironmentToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


#endif CNV_ENVIRONMENT_H