//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_environment_anim.h   
    Definition file for the dotXSI environment animation classes
*/

#ifndef CNV_ENVIRONMENT_ANIM_H
#define CNV_CENVIRONMENT_ANIM_H

#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"
#include "cnv_plottedanimation.h"

//! Class CEnvironmentAnimationFromXSI
/*!
    This is the class that implements getting the environment (ambience) animation from XSI into dotXSI
*/
class CEnvironmentAnimationFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CEnvironmentAnimationFromXSI();

//! Default destructor
	virtual ~CEnvironmentAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();


//! Get the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\return CAnimationPlotter* the instance of animation plotter
*/
	CAnimationPlotter *GetAnimationPlotter();

	
//! Set the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\param in_pAnimationPlotter the instance of animation plotter
	\return void
*/
	void SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter);

private:

	CAnimationPlotter	*m_pAnimationPlotter;
};


//! Class CEnvironmentAnimationToXSI
/*!
    This is the class that implements setting the environment (ambience) animation from dotXSI into XSI
*/
class CEnvironmentAnimationToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CEnvironmentAnimationToXSI();

//! Default destructor
	virtual ~CEnvironmentAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


#endif CNV_ENVIRONMENT_ANIM_H