//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_image_anim.h
/*!
	definition file for image animation classes
*/

#ifndef CNV_IMAGE_ANIM_H
#define CNV_IMAGE_ANIM_H



#include "dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "dotXSIConverter.h"
#include "cnv_plottedanimation.h"

//! class CXSIImageLibraryAnimationFromXSI
/*!
    definition for the conversion of image libraries animation from XSI
*/
class CXSIImageLibraryAnimationFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CXSIImageLibraryAnimationFromXSI();

//! Default destructor
	virtual ~CXSIImageLibraryAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();


//! Get the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\return CAnimationPlotter* the instance of animation plotter
*/
	CAnimationPlotter *GetAnimationPlotter();

	
//! Set the instance of CAnimationPlotter to collect animation to be plotted
/*!
	\param in_pAnimationPlotter the instance of animation plotter
	\return void
*/
	void SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter);

private:

	CAnimationPlotter	*m_pAnimationPlotter;
};

//! class CXSIImageAnimationFromXSI
/*!
    definition for the conversion of image clips animation from XSI
*/
class CXSIImageAnimationFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIImageAnimationFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIImageAnimationFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


//! class CXSIImageLibraryAnimationToXSI
/*!
    definition for the conversion of image libraries animation to XSI
*/
class CXSIImageLibraryAnimationToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CXSIImageLibraryAnimationToXSI();

//! Default destructor
	virtual ~CXSIImageLibraryAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSIImageAnimationToXSI
/*!
    definition for the conversion of image clips animation to XSI
*/
class CXSIImageAnimationToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIImageAnimationToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIImageAnimationToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};


#endif // CNV_IMAGE_H
