//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_material.h
/*!
	definition file for material classes
*/

#ifndef CNV_MATERIAL_H
#define CNV_MATERIAL_H

#include "dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "dotXSIConverter.h"

class CSLShaderInstanceData;
class CSLXSIShader;

typedef struct tagShaderInstanceDataRecord
{
	Parameter				m_Parameter;
	CValue					m_ParamValue;
	CRef					m_Owner;
	CSLXSIShader			*m_pShader;
	CSLShaderInstanceData	*m_pInstanceData;
} ShaderInstanceDataRecord;

//! class CMaterialLibraryFromXSI
/*!
    callback that implements getting material libraries from XSI
*/
class CMaterialLibraryFromXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMaterialLibraryFromXSI(short in_ExportType);

//! Default destructor
	virtual ~CMaterialLibraryFromXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CSIBCArray<ShaderInstanceDataRecord *>	m_InstanceDataRecords;

private:
	short m_ExportType;
};

//! class CMaterialLibraryFromXSI_RemoveUnused
/*!
    callback that implements removing the unused material from the material libraries
*/
class CMaterialLibraryFromXSI_RemoveUnused : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMaterialLibraryFromXSI_RemoveUnused();

//! Default destructor
	virtual ~CMaterialLibraryFromXSI_RemoveUnused();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CXSIMaterialFromXSI
/*!
    class that implements a callback to convert an XSIMaterial from XSI
*/
class CXSIMaterialFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIMaterialFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIMaterialFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CMaterialLibraryFromXSI *m_pMatLibCaller;
};

//! class CXSIShaderFromXSI
/*!
    class that implements a callback for getting XSI info from XSI
*/
class CXSIShaderFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIShaderFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIShaderFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CXSIMaterialFromXSI	*m_pMaterialCaller;
};

//! class CXSIInstanceDataFromXSI
/*!
    class that implements a callback for getting XSI info from XSI
*/
class CXSIInstanceDataFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIInstanceDataFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIInstanceDataFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CMaterialLibraryFromXSI *m_pMatLibConverter;
};


//! class CInstanceDataToXSI
/*!
    class that implements putting all the shader's instance data in XSI
*/
class CInstanceDataToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CInstanceDataToXSI();

//! Default destructor
	virtual ~CInstanceDataToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CSIBCArray<ShaderInstanceDataRecord *>	m_InstanceDataRecords;
};

//! class CMaterialLibraryToXSI
/*!
    class that implements putting a material library in XSI
*/
class CMaterialLibraryToXSI : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMaterialLibraryToXSI();

//! Default destructor
	virtual ~CMaterialLibraryToXSI();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CInstanceDataToXSI	*m_pInstanceDataCollector;
};

//! class CXSIMaterialToXSI
/*!
    class for the callbacks that puts a material in XSI
*/
class CXSIMaterialToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIMaterialToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIMaterialToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CMaterialLibraryToXSI *m_pMatLibCaller;
};

//! class CXSIShaderToXSI
/*!
    class that implements a callback to set a shader in XSI
*/
class CXSIShaderToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CXSIShaderToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CXSIShaderToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	CXSIMaterialToXSI	*m_pMaterialCaller;
};



#endif // CNV_MATERIAL_H
