//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_mixer.h
/*!
	definition file for mixer related classes
*/

#ifndef CNV_MIXER_H
#define CNV_MIXER_H



#include "dotXSIConverterCallback.h"
#include "cnv_hierarchytraversal.h"
#include "dotXSIConverter.h"
#include <Track.h>

//! class CMixerFromXSI
/*!
    class that implements a callback to get a mixer from XSI
*/
class CMixerFromXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CMixerFromXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CMixerFromXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CMixerToXSI
/*!
    class that implements a callback to import a mixer in XSI
*/
class CMixerToXSI : public CHierarchyTraverserCallback
{
public:

//! Default constructor
	CMixerToXSI(short in_CryFiletype);

//! Default destructor
	virtual ~CMixerToXSI();

//! Executes the callback
/*!
	\param in_pContext the dotXSI converter context
	\param in_XSIParent the current XSI model's parent
	\param in_pFTKParent the current FTK model's parent
	\param io_pXSIModel the current XSI model
	\param io_pFTKModel the current FTK model
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute( CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel);

//! Import the track and clips
/*!
	\param in_pTrackList the array of track to be imported
	\param in_TrackCount the number of track element in the array
	\param in_Compound the Compound into which the track must be added 
*/
	void ImportTracks(CdotXSIConverter *in_pContext, CSLTrack **in_pTrackList, int in_TrackCount, Model in_XSIModel, CValue in_Compound);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

//! class CMixerToXSIPostProcess
/*!
    class that implements the post processing task of mixer importation in XSI
*/
class CMixerToXSIPostProcess : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CMixerToXSIPostProcess();

//! Default destructor
	virtual ~CMixerToXSIPostProcess();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();
};

#endif // CNV_MIXER_H
