//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_plottedanimation.h
/*!
	animation plotting services
*/

#ifndef CNV_PLOTTEDANIMATION_H
#define CNV_PLOTTEDANIMATION_H

#include "dotXSIConverterCallback.h"
#include "dotXSIConverter.h"
#include <xsi_parameter.h>
#include <FCurve.h>

class CAnimationPlotterParameterEntry
{
public:
	CAnimationPlotterParameterEntry() {};
	~CAnimationPlotterParameterEntry() {};

	Parameter					m_XSIParameter;
	CSLTemplate					*m_pFTKFCurveOwner;
	CString						m_FTKFCurveName;
	CSLFCurve::EFCurveType		m_FTKFCurveType;
};


//! class CAnimationPlotter
/*!
    optimizer callback to plot animation data
*/
class CAnimationPlotter : public CdotXSIConverterCallback
{
public:

//! Default constructor
	CAnimationPlotter();

//! Default destructor
	virtual ~CAnimationPlotter();

//! Executes the callback
/*!
	\param in_pContext The converter context to be used in the execution
	\return CStatus Whether the execution failed or not
*/
	virtual CStatus Execute(CdotXSIConverter *in_pContext);

//! Returns the class id of the callback for logging purposes
/*!
	\return wchar_t the class id of the callback
*/
	virtual wchar_t *GetClassID();

	//! Adds a new CAnimationPlotterParameterEntry ensuring no duplicate in the list
/*!
	\return Nothing
*/
	SI_Void Add ( CAnimationPlotterParameterEntry* );

//! Returns the list of parameters to plot
/*!
	\return CSIBCArray<AnimationPlotterParameterEntry> the list of parameters to plot
*/
	CSIBCArray<CAnimationPlotterParameterEntry*>&GetParameterTable();


private:

	CSIBCArray<CAnimationPlotterParameterEntry*>	m_ParameterTable;
};





#endif // CNV_PLOTTEDANIMATION_H
