#ifndef _HELPER_H
#define _HELPER_H

#include <xsi_materiallibrary.h>

#include <vector>
#include <string>

extern void GetMaterialByName(CString& in_MaterialName, Material &out_Material);
extern void GetMaterialLibraryByMaterial(Material &in_Material, MaterialLibrary &out_MaterialLibrary);
extern LONG GetUnusedMaterialIDByMaterialLibrary(MaterialLibrary &in_MaterialLibrary);
extern bool IsFreeMaterialIDByMaterialLibrary(Material &in_Material, LONG in_MaterialID, MaterialLibrary &in_MaterialLibrary);
extern void UnhideAllClusters();
extern void HideClusters();
extern void ConvertObjectProperties(CString &in_Properties, std::vector<std::wstring> &out_Properties, CStringArray &in_NodeNames, CString &in_ModelName);

#endif
