//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file stdafx.h   
    include file for standard system include files
*/

#pragma once


#include <wchar.h>

#ifdef unix
# include <sys/time.h>
# include <sys/param.h>
# define _XSI_EXTERN_ extern "C"
# define XSIEXPORT
#else
# define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
# ifdef _WIN64
#  define _AMD64_
# endif
struct _CONTEXT;
typedef struct _CONTEXT CONTEXT;
typedef _CONTEXT* PCONTEXT;
#ifdef _WIN32
#include <intrin.h>
#endif
#include <windef.h>
# include <time.h>
# include <mmsystem.h>
# define _XSI_EXTERN_ extern "C" __declspec(dllexport)

#ifndef XSIEXPORT
# define XSIEXPORT __declspec(dllexport)
#endif

#endif



#ifdef unix
#define _wcsdup wcsdup
#define stricmp strcasecmp
#define si_getusername(struser, length) cuserid(struser)
#define MAX_PATH MAXPATHLEN

inline unsigned int timeGetTime() 
{
	struct timeval tv;
	struct timezone tz;

	gettimeofday(&tv, &tz);
	return tv.tv_sec*1000 + (tv.tv_usec/1000);
}

inline wchar_t* si_wcstok(wchar_t* wcs, wchar_t* delim)
{
	wchar_t* l_state;
	return wcstok(wcs, delim, &l_state);
}


#else
#define si_wcstok wcstok
#define si_getusername GetUserNameA
#endif


// TODO: reference additional headers your program requires here
#include <sicppsdk.h>

#include <string>
using std::string;