//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_COLLADA_IO.cpp   
    Implementation file for the dotXSI IO classes
*/
#include "stdafx.h"
#include <stdlib.h>
#include "cnv_COLLADA_IO.h"
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_parameter.h>

/****************************************************************************************
CDotXSI_Write
****************************************************************************************/

CCOLLADA_Write::CCOLLADA_Write() {};

CCOLLADA_Write::~CCOLLADA_Write() {};

wchar_t *CCOLLADA_Write::GetClassID() {	return L"COLLADA_Write";};

CStatus CCOLLADA_Write::Execute(CdotXSIConverter *in_pContext) 
{
	SI_Error	result = SI_SUCCESS;

	// Here we extract the Filename parameter
	Parameter	Filename = in_pContext->exportproperty().GetParameters().GetItem(L"Filename");
	Parameter	Extra = in_pContext->exportproperty().GetParameters().GetItem(L"ExportXSIExtra");

	if(Filename.IsValid())
	{
		// Here's how we extract the value
		CString		strFilePath = Filename.GetValue();

		if (!strFilePath.IsEmpty())
		{
			// then we convert it to an ansi string
			char		strFTKFileName[2048];
			wcstombs(strFTKFileName, strFilePath.GetWideString(), 2048);

			if ( (strlen(strFTKFileName) < 4) || 
				((_stricmp(&(strFTKFileName[strlen(strFTKFileName)-4]),".dae") != 0)  && 
				(_stricmp(&(strFTKFileName[strlen(strFTKFileName)-4]),".xml") != 0)))
			{
				strcat(strFTKFileName, ".dae");
			}

			// first, get the COLLADA Scene
			CSLCOLLADAScene* l_pCOLLADAScene = ((CSLCOLLADAScene*)(in_pContext->ftkscene()));

			// get the associated collada template <scene>
			CCOLLADATemplate* l_pCOLLADASceneTemplate = l_pCOLLADAScene->GetInstanciatedSceneTemplate();

			// get it's parent, the <COLLADA> template
			CCOLLADATemplate* l_pCOLLADATemplate = (CCOLLADATemplate*)l_pCOLLADASceneTemplate->Parent();

			// look for <asset> childs of the <COLLADA> template
			CdotXSITemplates* l_pCOLLADAAssetArray = l_pCOLLADATemplate->ChildrenOfType(CSIBCString("asset"));

			if (l_pCOLLADAAssetArray->GetCount() > 0)
			{
				CdotXSITemplate* l_pAssetTemplate;
				l_pCOLLADAAssetArray->Item(0, &l_pAssetTemplate);

				// look for <unit> child of the <asset> template
				CdotXSITemplates* l_pCOLLADAUnitArray = l_pAssetTemplate->ChildrenOfType(CSIBCString("unit"));

				if (l_pCOLLADAUnitArray->GetCount() > 0)
				{
					CCOLLADATemplate* l_pCOLLADAUnitTemplate;
					l_pCOLLADAUnitArray->Item(0, (CdotXSITemplate**)(&l_pCOLLADAUnitTemplate));

					// get the <unit> attributes
					CdotXSIParams &l_pAttibuteArray = l_pCOLLADAUnitTemplate->Attributes();

					// look for the meter= and name= attributes and modift their values.
					LONG loop;

					for (loop = 0; loop < l_pAttibuteArray.GetCount(); loop++)
					{
						CdotXSIParam* l_pAttribute;
						l_pAttibuteArray.Item(loop, &l_pAttribute);

						if (l_pAttribute->Name() == "meter")
						{
							char l_NewUnitString[4];
							strcpy(l_NewUnitString, "1.0");
							SI_TinyVariant l_NewUnit;
							l_NewUnit.p_cVal = l_NewUnitString;
							l_NewUnit.variantType = SI_VT_PCHAR;

							l_pAttribute->SetValue(l_NewUnit);
						}
						else if (l_pAttribute->Name() == "name")
						{
							char l_NewUnitString[6];
							strcpy(l_NewUnitString, "meter");
							SI_TinyVariant l_NewUnit;
							l_NewUnit.p_cVal = l_NewUnitString;
							l_NewUnit.variantType = SI_VT_PCHAR;

							l_pAttribute->SetValue(l_NewUnit);
						}
					}
				}
			}

			((CSLCOLLADAScene*)(in_pContext->ftkscene()))->ExportExtra((LONG)Extra.GetValue() ? TRUE : FALSE);
			// Write
			_SI_CALL(in_pContext->ftkscene()->Write(strFTKFileName), "Failed to write file");

			return (result == SI_SUCCESS) ? CStatus::OK : CStatus::Fail;
		}
		else
		{
			logerror(L"File name not specified");
			return CStatus::Fail;
		}
	}
	
	logerror(L"Could not find a parameter in the property page that has the name \"Filename\"");
	return CStatus::Fail;
};

