//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_image_anim.cpp
/*!
	implementation file for image animation classes
*/

#include "stdafx.h"
#include "cnv_image_anim.h"
#include <xsi_imageclip2.h>
#include <XSIImageLibrary.h>
#include <XSIImage.h>
#include <XSIImageFX.h>
#include "FTKUtil.h"
#include "cmdstubs.h"

/**************************************************************************************
CXSIImageLibraryAnimationFromXSI
**************************************************************************************/
CXSIImageLibraryAnimationFromXSI::CXSIImageLibraryAnimationFromXSI() 
{
	m_pAnimationPlotter = NULL;
};

CXSIImageLibraryAnimationFromXSI::~CXSIImageLibraryAnimationFromXSI() {};

CStatus CXSIImageLibraryAnimationFromXSI::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;
	CSLImageLibrary		*l_pFTKImageLibrary = in_pContext->ftkscene()->GetImageLibrary();

	if ( !l_pFTKImageLibrary )
	{
		return status;
	}


	LONG l_nFTKImageClipCount = l_pFTKImageLibrary->GetImageCount();
	CSLImage** l_ppFTKImageClipArray = l_pFTKImageLibrary->GetImageList();

	for (LONG loop = 0; loop < l_nFTKImageClipCount; loop++)
	{
		ImageClip2 l_XSIImageClip;
		
		CSIBCUserData *l_pUserData = l_ppFTKImageClipArray[loop]->FindUserData("CREF");
		if(l_pUserData)
		{
			CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
			l_XSIImageClip = (ImageClip2) *l_pCRef;

			FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop], CSLFCurve::SI_CROP_MIN_X, l_XSIImageClip.GetParameter(CString(L"Xmin")), m_pAnimationPlotter);
			FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop], CSLFCurve::SI_CROP_MAX_X, l_XSIImageClip.GetParameter(CString(L"Xmax")), m_pAnimationPlotter);
			FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop], CSLFCurve::SI_CROP_MIN_Y, l_XSIImageClip.GetParameter(CString(L"Ymin")), m_pAnimationPlotter);
			FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop], CSLFCurve::SI_CROP_MAX_Y, l_XSIImageClip.GetParameter(CString(L"Ymax")), m_pAnimationPlotter);

			if (l_ppFTKImageClipArray[loop]->ImageFX())
			{
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_HUE, l_XSIImageClip.GetParameter(CString(L"Hue")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_GAIN, l_XSIImageClip.GetParameter(CString(L"Gain")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_SATURATION, l_XSIImageClip.GetParameter(CString(L"Saturation")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_BRIGHTNESS, l_XSIImageClip.GetParameter(CString(L"Brightness")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_BLUR_RADIUS, l_XSIImageClip.GetParameter(CString(L"Radius")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_BLUR_AMOUNT, l_XSIImageClip.GetParameter(CString(L"Amount")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_BLUR_ALPHA, l_XSIImageClip.GetParameter(CString(L"BlurAlpha")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_SCALING_TYPE, l_XSIImageClip.GetParameter(CString(L"Type")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_SCALE_X, l_XSIImageClip.GetParameter(CString(L"ResX")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_SCALE_Y, l_XSIImageClip.GetParameter(CString(L"ResY")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_FLIP_X, l_XSIImageClip.GetParameter(CString(L"FlipX")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_FLIP_Y, l_XSIImageClip.GetParameter(CString(L"FlipY")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_RGBA2GRAYSCALE, l_XSIImageClip.GetParameter(CString(L"GrayScale")), m_pAnimationPlotter);
				FTKUParameterAnimationFromXSI(l_ppFTKImageClipArray[loop]->ImageFX(), CSLFCurve::SI_BITS_PER_CHANNEL, l_XSIImageClip.GetParameter(CString(L"SixteenBitsPerChannel")), m_pAnimationPlotter);
			}
		}
	}

	return status;
}

wchar_t *CXSIImageLibraryAnimationFromXSI::GetClassID(){return L"CXSIImageLibraryAnimationFromXSI";}

CAnimationPlotter *CXSIImageLibraryAnimationFromXSI::GetAnimationPlotter()
{
	return m_pAnimationPlotter;
}

void CXSIImageLibraryAnimationFromXSI::SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter)
{
	m_pAnimationPlotter = in_pAnimationPlotter;
}



/**************************************************************************************
CXSIImageLibraryAnimationToXSI
**************************************************************************************/
CXSIImageLibraryAnimationToXSI::CXSIImageLibraryAnimationToXSI() {};

CXSIImageLibraryAnimationToXSI::~CXSIImageLibraryAnimationToXSI() {};

CStatus CXSIImageLibraryAnimationToXSI::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;
	CSLImageLibrary		*l_pFTKImageLibrary = in_pContext->ftkscene()->GetImageLibrary();

	if(l_pFTKImageLibrary == NULL)
		return status;


	LONG l_nFTKImageClipCount = l_pFTKImageLibrary->GetImageCount();
	CSLImage** l_ppFTKImageClipArray = l_pFTKImageLibrary->GetImageList();

	for (LONG loop = 0; loop < l_nFTKImageClipCount; loop++)
	{
		ImageClip2 l_XSIImageClip;
		
		CSIBCUserData *l_pUserData = l_ppFTKImageClipArray[loop]->FindUserData("CREF");
		if(l_pUserData && l_ppFTKImageClipArray[loop]->GetFCurveCount())
		{
			CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
			l_XSIImageClip = (ImageClip2) *l_pCRef;

			if (l_XSIImageClip.IsValid())
			{
				LONG loop2;

				CSLFCurve** l_ppFCurve = l_ppFTKImageClipArray[loop]->FCurves();
				LONG l_nFCurveCount = l_ppFTKImageClipArray[loop]->GetFCurveCount();
				CParameterRefArray l_Parameters = l_XSIImageClip.GetParameters();

				for (loop2 = 0; loop2 < l_nFCurveCount; loop2++)
				{
					FTKUParameterAnimationToXSI(l_ppFCurve[loop2], l_Parameters);
				}

				if (l_ppFTKImageClipArray[loop]->ImageFX())
				{
					l_ppFCurve = l_ppFTKImageClipArray[loop]->ImageFX()->FCurves();
					l_nFCurveCount = l_ppFTKImageClipArray[loop]->ImageFX()->GetFCurveCount();

					for (loop2 = 0; loop2 < l_nFCurveCount; loop2++)
					{
						FTKUParameterAnimationToXSI(l_ppFCurve[loop2], l_Parameters);
					}
				}
			}
		}
	}

	return status;
}

wchar_t *CXSIImageLibraryAnimationToXSI::GetClassID(){return L"CXSIImageLibraryAnimationToXSI";}

