//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_info.cpp   
    Implementation file for the dotXSI info classes
*/

#include "stdafx.h"
#include "cnv_info.h"
#include "FTKUtil.h"
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_parameter.h>
#include <xsi_project.h>
#include <xsi_preferences.h>
#include <xsi_time.h>
#include <xsi_uitoolkit.h>
#include <xsi_progressbar.h>
#include <xsi_kinematics.h>
#include <xsi_kinematicstate.h>
#include <xsi_model.h>
#include <Scene.h>
#include <SceneInfo.h>
#include <CoordinateSystem.h>
#include <Angle.h>
#include <FileInfo.h>
#include <XSITransform.h>
#include "cmdstubs.h"


/****************************************************************************************
CSceneInfoFromXSI
****************************************************************************************/

CSceneInfoFromXSI::CSceneInfoFromXSI() {};

CSceneInfoFromXSI::~CSceneInfoFromXSI() {};

wchar_t *CSceneInfoFromXSI::GetClassID() {	return L"CSceneInfoFromXSI";};

CStatus CSceneInfoFromXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	CTime			time;
	Preferences		preferences = in_pContext->application().GetPreferences();

	//***************************************************************************************
	// Set the scene info
	//***************************************************************************************
	CSLSceneInfo *l_pSceneInfo = in_pContext->ftkscene()->SceneInfo();


	// check the format and set the timing type accordingly

	if(in_pContext->ftkscene()->Parser()->GetdotXSIFormat() == FORMAT_COLLADA)
	{
		l_pSceneInfo->SetTimingType(CSLSceneInfo::SI_SECONDS);
	}
	else
	{
		// Set the timing in frames for now
		l_pSceneInfo->SetTimingType(CSLSceneInfo::SI_FRAMES);
	}

	// get the starting frame from XSI
	float startframe;
	startframe = COMMANDS::GetValue(CString(L"PlayControl.In"), time.GetTime());
	l_pSceneInfo->SetStart(startframe);

	// get the ending frame from XSI
	float endframe;
	endframe = COMMANDS::GetValue(CString(L"PlayControl.Out"), time.GetTime());
	l_pSceneInfo->SetEnd(endframe);

	// get the frame rate from XSI
	l_pSceneInfo->SetFrameRate((float)time.GetFrameRate());

	//***************************************************************************************
	// Set the file info
	//***************************************************************************************
	char tmpstring[1024];
	CSLFileInfo *l_pFileInfo = in_pContext->ftkscene()->FileInfo();

	// get the version of XSI
	CString version = in_pContext->application().GetVersion();
	sprintf(tmpstring, "Softimage|XSI version %s", version.GetWideString());
	l_pFileInfo->SetOriginator(tmpstring);

	// get the project name
	Project project = in_pContext->application().GetActiveProject();
	l_pFileInfo->SetProjectName((char*)project.GetName().GetAsciiString());

	// get the user name
	DWORD stringsize = 1024;
	si_getusername(tmpstring, &stringsize);
	l_pFileInfo->SetUsername(tmpstring);

	//***************************************************************************************
	// the date is automatically set by the FTK
	//***************************************************************************************

	//***************************************************************************************
	// Set the coordinate system
	//***************************************************************************************
	in_pContext->ftkscene()->CoordinateSystem()->SetCoordinateSystemStyle(CSLCoordinateSystem::SI_SOFTIMAGE_3D);

	//***************************************************************************************
	// Set the angle type
	//***************************************************************************************
	in_pContext->ftkscene()->Angle()->SetAngleType(CSLAngle::SI_DEGREES);

	return status;
};

/****************************************************************************************
CSceneInfoToXSI
****************************************************************************************/

CSceneInfoToXSI::CSceneInfoToXSI() {};

CSceneInfoToXSI::~CSceneInfoToXSI() {};

wchar_t *CSceneInfoToXSI::GetClassID() {	return L"CSceneInfoToXSI";};

CStatus CSceneInfoToXSI::Execute(CdotXSIConverter *in_pContext) 
{
	CStatus			status = CStatus::OK;
	CTime			time;
	Preferences		preferences = in_pContext->application().GetPreferences();

	//***************************************************************************************
	// Set the scene playback info
	//***************************************************************************************
	CSLSceneInfo *l_pSceneInfo = in_pContext->ftkscene()->SceneInfo();

	// Did the user specify to skip the timeline settings?
	//
	bool bImportTimelineSettings = in_pContext->importproperty().GetParameterValue(L"ImportTimelineSettings");
	if (bImportTimelineSettings)
	{
		// set the starting frame in XSI
		if(fabs(l_pSceneInfo->GetStart()) != FLT_MAX)
		{
			CTime time;
			float start = l_pSceneInfo->GetStart();
			if(l_pSceneInfo->GetTimingType() == CSLSceneInfo::SI_SECONDS)
				start = start * (float)time.GetFrameRate();

			COMMANDS::SetValue(CString(L"PlayControl.In"), CValue(start),CValue(0.0));

			// set the current frame in XSI
			COMMANDS::SetValue(CString(L"PlayControl.Current"), CValue(start),CValue(0.0));
		}

		// set the ending frame in XSI
		if(fabs(l_pSceneInfo->GetEnd()) != FLT_MAX)
		{
			CTime time;
			float end = l_pSceneInfo->GetEnd();
			if(l_pSceneInfo->GetTimingType() == CSLSceneInfo::SI_SECONDS)
				end = end * (float)time.GetFrameRate();

			COMMANDS::SetValue(CString(L"PlayControl.Out"), CValue(end),CValue(0.0));
		}
	}
	
	// Set the frame rate no matter what "import timeline settings" is set to (TRUE or FALSE)
	// This will scale the animations accordingly. The original frame rate will be restored once
	// import is complete.
	//
	// get the frame rate from XSI
	if(l_pSceneInfo->GetFrameRate() != 0.0f)
	{
		if (l_pSceneInfo->GetFrameRate() == 29.970030f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* NTSC */ (LONG)10, CValue(0.0));
		else if (l_pSceneInfo->GetFrameRate() == 25.0f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* PAL */ (LONG)8, CValue(0.0));
		else if (l_pSceneInfo->GetFrameRate() == 24.0f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* FILM */ (LONG)7, CValue(0.0));
		else if (l_pSceneInfo->GetFrameRate() == 30.0f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* 30 */ (LONG)19, CValue(0.0));
		else if (l_pSceneInfo->GetFrameRate() == 23.9760250f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* 2397 */ (LONG)13, CValue(0.0));
		else if (l_pSceneInfo->GetFrameRate() == 59.940060f)
			COMMANDS::SetValue(CString(L"PlayControl.Format"), /* 5994 */ (LONG)25, CValue(0.0));
		else
			COMMANDS::SetValue(CString(L"PlayControl.Rate"), CValue(l_pSceneInfo->GetFrameRate()),CValue(0.0));
	}

	//***************************************************************************************
    // Set the coordinate system
    //***************************************************************************************
	if (IsZUp(in_pContext->ftkscene()->CoordinateSystem()))
	{
		// Create an empty model
		CSLModel* l_pFTKRoot = in_pContext->ftkscene()->Root();

		CSLModel* l_pSceneRoot = NULL;

		if (in_pContext->GetFormat() == COLLADA_FORMAT_1_4_1)
		{
			if (in_pContext->args().GetCount() == 1 ||
				(in_pContext->args().GetCount() > 1 && in_pContext->args()[1].IsEmpty()))
			{
				Model	l_XSIRoot = in_pContext->scene().GetRoot();
				Model	l_XSIModel;

				// create a new model and set the -90 x rotation on it
				_XSI_CALL(l_XSIRoot.AddModel(CRefArray(), CString(L"ZUpToYUp"), l_XSIModel), L"Failed to add ZUpToYUp Model object");

				KinematicState l_XSIKineState = l_XSIModel.GetKinematics().GetLocal();

				MATH::CTransformation l_Transformation;

				l_Transformation.SetIdentity();
				double l_XCorrection = -90;
				CNV_DEGTORAD(l_XCorrection);
				l_Transformation.SetRotationFromXYZAnglesValues(l_XCorrection,0.0,0.0);

				l_XSIKineState.PutTransform( l_Transformation );

				// make this model the "root" of this import by setting the "arg[1]"
				// see CFTKHierarchyTraverser::Execute for more info on this.
				CValue l_AgrValue(l_XSIModel);
	
				if (in_pContext->args().GetCount() == 1)
				{
					in_pContext->args().Add(l_AgrValue);
				}
				else
				{
					in_pContext->args()[1] = l_AgrValue;
				}
			}
		}
		else
		{
			// in dotXSI 6.0, only fix the coord system if the scene was completly exported (no export selected)
			// and put the correction transform on the Scene Root element.
			// The scene is considered to be completly exported when the Scene Root is in the file
			// in other word, if there's only one child of the FTK root and that child as no primitive...
			// assum it's the Scene Root.
			if (l_pFTKRoot->GetChildrenCount() == 1)
			{
				l_pSceneRoot = l_pFTKRoot->GetChildrenList()[0];

				if (l_pSceneRoot->Primitive())
				{
					l_pSceneRoot = NULL;
				}
			}

			if (l_pSceneRoot)
			{
				// Set the transformation
				CSLXSITransform* l_pXSITransform = l_pSceneRoot->XSITransform();
				if (l_pXSITransform)
				{
					CSIBCVector3D l_vRotation = l_pXSITransform->GetEulerRotation();
					
					// reorient the Scene_Root so that has a -90 deg in X to adjust to Y UP axis.
					l_vRotation.m_fX = l_vRotation.m_fX - 90.0f;

					l_pXSITransform->SetEulerRotation(l_vRotation);
				}
			}
		}
	}

	return status;
};

/**************************************************************************************
CProcessTimer
**************************************************************************************/

LONG		CProcessTimer::m_start = 0;
LONG		CProcessTimer::m_current = 0;
LONG		CProcessTimer::m_lasttime = 0;
LONG		CProcessTimer::m_NumberOfTasks = 0;
LONG		CProcessTimer::m_CurrentTask = 0;
ProgressBar	CProcessTimer::m_ProgressBar;
bool		CProcessTimer::m_Interactive = false;

CProcessTimer::CProcessTimer(wchar_t* in_pMessage) 
{
	m_Message = CString(in_pMessage);
	m_NumberOfTasks ++;
};

CProcessTimer::~CProcessTimer() 
{
	if(m_Interactive)
	{
		m_ProgressBar.PutVisible( false );	
	}
};

CStatus CProcessTimer::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;

	// Here we extract the Verbose parameter
	CValue l_VerboseValue = in_pContext->importproperty().GetParameterValue(L"Verbose");
	if(l_VerboseValue.IsEmpty())
	{
		l_VerboseValue = in_pContext->exportproperty().GetParameterValue(L"Verbose");
	}

	m_current = timeGetTime();
	if(l_VerboseValue == true)
	{
		logmessage(L"%d mSec - cumulative: %d mSec", m_current - m_lasttime,  m_current - m_start);
		logmessage(L"%s", m_Message.GetWideString());
	}

	if(m_Interactive)
	{
		m_ProgressBar.PutMinimum(0);
		m_ProgressBar.PutMaximum( m_NumberOfTasks - 1 );
		m_ProgressBar.PutStep( 1 );
		m_ProgressBar.PutCaption( L"Crosswalk converter" );
		m_ProgressBar.PutValue(m_CurrentTask);
		m_ProgressBar.PutStatusText(m_Message.GetWideString());
		m_ProgressBar.PutVisible( true );	

		if(m_ProgressBar.IsCancelPressed())
		{
			status = CStatus::False;
			m_ProgressBar.PutVisible( false );
		}
	}

	m_CurrentTask ++;
	m_lasttime = timeGetTime();
	return status;
}

wchar_t *CProcessTimer::GetClassID(){return L"CProcessTimer";}

void	CProcessTimer::Reset()
{
	m_start = timeGetTime();
	m_lasttime = timeGetTime();
	m_current = timeGetTime();
	m_CurrentTask = 0;
}

void	CProcessTimer::ResetTasks()
{
	m_NumberOfTasks = 0;

    // Setup the progress
    Application app;
	m_Interactive = app.IsInteractive();


	if(m_Interactive)
	{
		UIToolkit kit = app.GetUIToolkit();
		m_ProgressBar = kit.GetProgressBar();
	}
}

void CProcessTimer::ShowSubtitle ( CString in_Subtitle )
{
	if(m_Interactive)
	{
		m_ProgressBar.PutStatusText(CString(m_Message + CString(L" - ") + in_Subtitle));
		m_ProgressBar.PutVisible( false );
	}
}
