//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_instance.cpp
/*!
	implementation file for instance related classes
*/

#include "stdafx.h"
#include "cmdstubs.h"
#include "cnv_instance.h"
#include <xsi_application.h>
#include <xsi_x3dobject.h>
#include <xsi_model.h>
#include <xsi_null.h>
#include <Instance.h>
#include <Model.h>



/**************************************************************************************
CInstanceFromXSI
**************************************************************************************/
CInstanceFromXSI::CInstanceFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CInstanceFromXSI::~CInstanceFromXSI() {};

CStatus CInstanceFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	X3DObject XSIModel = (X3DObject) *io_pXSIModel;

	if((wcscmp(XSIModel.GetType().GetWideString(), L"#model") == 0))
	{
		X3DObject XSIMaster( COMMANDS::GetMaster( XSIModel.GetFullName() ) );

		if (XSIMaster.IsValid())
		{
			CSLModel *l_pInstanceMdl;
			CSLModel *l_pParent = (CSLModel *) in_pFTKParent;

			l_pInstanceMdl = l_pParent->AddInstance();
			*io_pFTKModel = l_pInstanceMdl;
			l_pInstanceMdl->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));

			CSLInstance *l_pInstancePrimitive = (CSLInstance*)l_pInstanceMdl->Primitive();

			CSLModel *l_pMasterMdl = in_pContext->ftkscene()->FindModelRecursively( (char*)XSIMaster.GetFullName().GetAsciiString(), in_pContext->ftkscene()->Root() );

			l_pInstancePrimitive->SetReference(l_pMasterMdl);
		}
	}

	return status;
}

wchar_t *CInstanceFromXSI::GetClassID(){return L"CInstanceFromXSI";}


/**************************************************************************************
CInstanceToXSI
**************************************************************************************/
CInstanceToXSI::CInstanceToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CInstanceToXSI::~CInstanceToXSI() {};

CStatus CInstanceToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	
	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;
	if(l_pFTKModel->Primitive() && (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_INSTANCE))
	{
		CSLInstance *l_pFTKInstance = (CSLInstance*)l_pFTKModel->Primitive();

		X3DObject	l_XSIParent = (X3DObject) in_XSIParent;

		CSLModel *l_pReference = l_pFTKInstance->GetReference();

		CSIBCUserData* l_pUserData = NULL;

		if (l_pReference)
			l_pUserData = l_pFTKInstance->GetReference()->FindUserData("CREF");

		if(l_pUserData != NULL)
		{

			CRef *l_pCRef = (CRef*)(l_pUserData->GetData());

			X3DObject l_XSIMasterModel = (X3DObject) *l_pCRef;

			// instanciate the master model
			CValueArray l_CValueArray = COMMANDS::Instantiate
			( 
				l_XSIMasterModel.GetFullName(), 
				CValue( (LONG)1 ), 
				siNoParent, 
				siNoGrouping, 
				siSetSelection, 
				siGlobalXForm, 
				CValue(1.0), 
				CValue(1.0), 
				CValue(1.0), 
				CValue(0.0), 
				CValue(0.0), 
				CValue(0.0), 
				CValue(0.0), 
				CValue(0.0), 
				CValue(0.0),
				CValue( (LONG)1 )
			);

			*io_pXSIModel = l_CValueArray[0];

			// parent the new instance
			CRefArray l_NewChildArray;
			l_NewChildArray.Add(*io_pXSIModel);
			l_XSIParent.AddChild(l_NewChildArray);

			l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
		}
		else
		{
			X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
			Model		l_XSIModel;

			_XSI_CALL(l_XSIParent.AddModel(CRefArray(), CString(L"unknown"), l_XSIModel), L"Failed to add a Model object");
			*io_pXSIModel = l_XSIModel;

			l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_XSIModel));
		}
	}
	
	return status;
}

wchar_t *CInstanceToXSI::GetClassID(){return L"CInstanceToXSI";}


/**************************************************************************************
CUnresolvedInstanceToXSI
**************************************************************************************/
CUnresolvedInstanceToXSI::CUnresolvedInstanceToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CUnresolvedInstanceToXSI::~CUnresolvedInstanceToXSI() {};

CStatus CUnresolvedInstanceToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	
	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;
	if(l_pFTKModel->Primitive() && (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_INSTANCE))
	{
		CSLInstance *l_pFTKInstance = (CSLInstance*)l_pFTKModel->Primitive();

		CSIBCUserData* l_pUserData = l_pFTKModel->FindUserData("CREF");
		if(l_pUserData != NULL)
		{

			CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
			X3DObject l_Instance = (X3DObject) *l_pCRef;
			X3DObject XSIMaster( COMMANDS::GetMaster( l_Instance.GetFullName() ) );

			if (!XSIMaster.IsValid() && l_pFTKInstance->GetReference())
			{
				X3DObject	l_XSIParent = (X3DObject) in_XSIParent;

				CSIBCUserData* l_pUserData = l_pFTKInstance->GetReference()->FindUserData("CREF");
				if(l_pUserData != NULL)
				{

					CRef *l_pCRef = (CRef*)(l_pUserData->GetData());

					X3DObject l_XSIMasterModel = (X3DObject) *l_pCRef;

					// instanciate the master model
					CValueArray l_CValueArray = COMMANDS::Instantiate
					( 
						l_XSIMasterModel.GetFullName(), 
						CValue( (LONG)1 ), 
						siNoParent, 
						siNoGrouping, 
						siSetSelection, 
						siGlobalXForm, 
						CValue(1.0), 
						CValue(1.0), 
						CValue(1.0), 
						CValue(0.0), 
						CValue(0.0), 
						CValue(0.0), 
						CValue(0.0), 
						CValue(0.0), 
						CValue(0.0),
						CValue( (LONG)1 )
					);

					*io_pXSIModel = l_CValueArray[0];

					// parent the new instance
					CRefArray l_NewChildArray;
					l_NewChildArray.Add(*io_pXSIModel);
					l_XSIParent.AddChild(l_NewChildArray);

					CSIBCUserData* l_pUserData = l_pFTKModel->FindUserData("CREF");
					if(l_pUserData != NULL)
					{
						l_pUserData->SetData(in_pContext->AddCRef(*io_pXSIModel));
					}
					else
					{
						l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
					}
				}

				// now we reparent our children to the new instance
				X3DObject l_newInstance = (X3DObject) *io_pXSIModel;

				X3DObject l_InstanceParent = (X3DObject) l_Instance.GetParent();
				CRefArray l_InstanceRefArray;
				l_InstanceRefArray.Add(l_newInstance);
				
				l_InstanceParent.AddChild(l_InstanceRefArray);
				if(l_Instance.GetChildren().GetCount())
				{
					l_newInstance.AddChild(l_Instance.GetChildren());
				}

				// delete the old placeholder
				COMMANDS::DeleteObj(l_Instance.GetFullName());
			}
		}
	}
	
	return status;
}

wchar_t *CUnresolvedInstanceToXSI::GetClassID(){return L"CUnresolvedInstanceToXSI";}