//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_light_anim.cpp
/*!
	light animation conversion classes
*/

#include "stdafx.h"
#include "cnv_light_anim.h"
#include <xsi_x3dobject.h>
#include <xsi_light.h>
#include <Model.h>
#include <Light.h>
#include <PointLight.h>
#include <SpotLight.h>
#include <InfiniteLight.h>
#include <DirectionalLight.h>
#include <xsi_shader.h>
#include <xsi_kinematics.h>
#include <xsi_directed.h>
#include <FTKUtil.h>


/**************************************************************************************
CLightAnimationFromXSI
**************************************************************************************/
CLightAnimationFromXSI::CLightAnimationFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) 
{
	m_pAnimationPlotter = NULL;
};

CLightAnimationFromXSI::~CLightAnimationFromXSI() {};

CStatus CLightAnimationFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	
	if (*io_pFTKModel && ((*io_pFTKModel)->Type() == CSLTemplate::SI_MODEL))
	{
		CSLModel* l_pFTKModel = (CSLModel*)*io_pFTKModel;

		if (l_pFTKModel && l_pFTKModel->Primitive() 
			&& ( (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_POINT_LIGHT)
			|| (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_DIRECTIONAL_LIGHT)
				 || (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_SPOT_LIGHT) ) )
		{
			CSLLight* l_pFTKLight = (CSLLight*)l_pFTKModel->Primitive();
			Light l_XSILight = (Light) *io_pXSIModel;

			// find the soft_light shader, we only support softimage.soft_light.1
			CRefArray	l_XSIShaderArray = l_XSILight.GetShaders();
			Shader		l_XSILightShader;

			if(l_XSIShaderArray.GetCount() > 0)
			{
				Shader		l_tmpShader = (Shader) l_XSIShaderArray[0];
				CString		l_ProgID = l_tmpShader.GetProgID();

				if(l_ProgID == CString(L"Softimage.soft_light.1"))
				{
					l_XSILightShader = l_tmpShader;
				}
			}

			CParameterRefArray l_LightParameters = l_XSILight.GetParameters();

			// extract the light position animation
			FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_POSITION_X, m_pAnimationPlotter, L"posx");
			FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_POSITION_Y, m_pAnimationPlotter, L"posy");
			FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_POSITION_Z, m_pAnimationPlotter, L"posz");

			// extract light animation depending on the type
			LONG l_LightType = ((Parameter)l_LightParameters.GetItem(L"Type")).GetValue();
			switch(l_LightType)
			{
				case 1: // directional light
				{
					// extract the orientation animation
					FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_ORIENTATION_X, m_pAnimationPlotter, L"rotx");
					FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_ORIENTATION_Y, m_pAnimationPlotter, L"roty");
					FTKUParameterAnimationFromXSI(l_pFTKLight, l_LightParameters, CSLFCurve::SI_ORIENTATION_Z, m_pAnimationPlotter, L"rotz");
				} break;

				case 2: // spot light
				{
					CSLSpotLight *l_pFTKSpotLight = (CSLSpotLight*)l_pFTKLight;

					// animation
					FTKUParameterAnimationFromXSI(l_pFTKSpotLight, l_LightParameters, CSLFCurve::SI_CONE, m_pAnimationPlotter, L"LightCone");

					if (l_XSILightShader.IsValid())
					{
						FTKUParameterAnimationFromXSI(l_pFTKSpotLight, l_XSILightShader.GetParameters(), CSLFCurve::SI_SPREAD, m_pAnimationPlotter, L"spread");
					}

					Directed l_XSISpotLight = (Directed) l_XSILight;
					X3DObject l_XSIInterest = l_XSISpotLight.GetInterest();

					if(l_XSIInterest.IsValid() && (l_XSIInterest.IsAnimated()))
					{
						CParameterRefArray l_InterestParameters = l_XSIInterest.GetParameters();
						// extract the interest position animation
						FTKUParameterAnimationFromXSI(l_pFTKSpotLight, l_InterestParameters, CSLFCurve::SI_INTEREST_X, m_pAnimationPlotter, L"posx");
						FTKUParameterAnimationFromXSI(l_pFTKSpotLight, l_InterestParameters, CSLFCurve::SI_INTEREST_Y, m_pAnimationPlotter, L"posy");
						FTKUParameterAnimationFromXSI(l_pFTKSpotLight, l_InterestParameters, CSLFCurve::SI_INTEREST_Z, m_pAnimationPlotter, L"posz");
					}
				} break;
			}

			if(l_XSILightShader.IsValid() && (l_XSILightShader.IsAnimated(siAnySource, true)))
			{
				CParameterRefArray l_LightshaderParameters = l_XSILightShader.GetParameters();

				FTKUParameterAnimationFromXSI( l_pFTKLight, CSLFCurve::SI_COLOR_R, l_XSILightShader.GetParameter(CString(L"color")).GetParameter(CString(L"red")), m_pAnimationPlotter );
				FTKUParameterAnimationFromXSI( l_pFTKLight, CSLFCurve::SI_COLOR_G, l_XSILightShader.GetParameter(CString(L"color")).GetParameter(CString(L"green")), m_pAnimationPlotter );
				FTKUParameterAnimationFromXSI( l_pFTKLight, CSLFCurve::SI_COLOR_B, l_XSILightShader.GetParameter(CString(L"color")).GetParameter(CString(L"blue")), m_pAnimationPlotter );

				if (l_pFTKLight->LightInfo())
				{
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_FALLOFF_ACTIVE, m_pAnimationPlotter, L"atten");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_FALLOFF_START, m_pAnimationPlotter, L"start");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_FALLOFF_END, m_pAnimationPlotter, L"stop");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_SHADOWS_ENABLED, m_pAnimationPlotter, L"shadow");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_UMBRA, m_pAnimationPlotter, L"factor");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_LIGHT_AS_ENERGY, m_pAnimationPlotter, L"use_color");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_ENERGY_FACTOR, m_pAnimationPlotter, L"energy_factor");
					FTKUParameterAnimationFromXSI(l_pFTKLight->LightInfo(), l_LightshaderParameters, CSLFCurve::SI_INTENSITY, m_pAnimationPlotter, L"intensity");
				}
			}
		}
	}

	return status;
}

wchar_t *CLightAnimationFromXSI::GetClassID(){return L"CXSIImageLibraryAnimationFromXSI";}

CAnimationPlotter *CLightAnimationFromXSI::GetAnimationPlotter()
{
	return m_pAnimationPlotter;
}

void CLightAnimationFromXSI::SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter)
{
	m_pAnimationPlotter = in_pAnimationPlotter;
}



/**************************************************************************************
CLightAnimationToXSI
**************************************************************************************/
CLightAnimationToXSI::CLightAnimationToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CLightAnimationToXSI::~CLightAnimationToXSI() {};

CStatus CLightAnimationToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	LONG loop;
	
	if (*io_pFTKModel && ((*io_pFTKModel)->Type() == CSLTemplate::SI_MODEL))
	{
		CSLModel* l_pFTKModel = (CSLModel*)*io_pFTKModel;

		if (l_pFTKModel && l_pFTKModel->Primitive() 
			&& ( (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_POINT_LIGHT)
			|| (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_DIRECTIONAL_LIGHT)
				 || (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_SPOT_LIGHT) ) )
		{
			CSLLight* l_pFTKLight = (CSLLight*)l_pFTKModel->Primitive();

			if( l_pFTKLight->GetFCurveCount() )
			{
				Light l_XSILight = (Light) *io_pXSIModel;


				// find the soft_light shader, we only support softimage.soft_light.1
				CRefArray	l_XSIShaderArray = l_XSILight.GetShaders();
				Shader		l_XSILightShader;

				if(l_XSIShaderArray.GetCount() > 0)
				{
					Shader		l_tmpShader = (Shader) l_XSIShaderArray[0];
					CString		l_ProgID = l_tmpShader.GetProgID();

					if(l_ProgID == CString(L"Softimage.soft_light.1"))
					{
						l_XSILightShader = l_tmpShader;
					}
				}

				CSLFCurve** l_ppFTKFCurve = l_pFTKLight->FCurves();
				LONG l_nFTKFCurveCount = l_pFTKLight->GetFCurveCount();

				Directed l_XSISpotLight = (Directed) l_XSILight;
				CParameterRefArray l_InterestParams;

				if(l_XSISpotLight.IsValid())
				{
					l_InterestParams = l_XSISpotLight.GetInterest().GetParameters();
				}

				CParameterRefArray l_ShaderParams = l_XSILightShader.GetParameters();
				CParameterRefArray l_LightParams = l_XSILight.GetParameters();

				for (loop = 0; loop < l_nFTKFCurveCount; loop++)
				{
					// special case: in the case of the camera interest animation we want to pass the interest itself
					if ((l_pFTKLight->Type() == CSLTemplate::SI_SPOT_LIGHT)
						&& ( l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_INTEREST_X
							|| l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_INTEREST_Y
							|| l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_INTEREST_Z ) )
					{

						FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_InterestParams);
					}
					else if ( (l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_SPREAD)
							|| (l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_COLOR_R)
							|| (l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_COLOR_G)
							|| (l_ppFTKFCurve[loop]->GetFCurveType() == CSLFCurve::SI_COLOR_B) )
					{
						FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_ShaderParams);
					}
					else
					{
						FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_LightParams);
					}
				}

				if (l_pFTKLight->LightInfo())
				{
					l_ppFTKFCurve = l_pFTKLight->LightInfo()->FCurves();
					l_nFTKFCurveCount = l_pFTKLight->LightInfo()->GetFCurveCount();

					for (loop = 0; loop < l_nFTKFCurveCount; loop++)
					{
						FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_ShaderParams);
					}
				}
			}
		}
	}

	return status;
}

wchar_t *CLightAnimationToXSI::GetClassID(){return L"CLightAnimationToXSI";}

