//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_model.cpp
/*!
	implementation file for model related classes
*/

#include "stdafx.h"
#include "cmdstubs.h"
#include "cnv_model.h"
#include <xsi_application.h>
#include <xsi_x3dobject.h>
#include <xsi_model.h>
#include <Model.h>
#include <Primitive.h>
#include <XSIUserData.h> 

/**************************************************************************************
CModelFromXSI
**************************************************************************************/
CModelFromXSI::CModelFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CModelFromXSI::~CModelFromXSI() {};

CStatus CModelFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	X3DObject l_XSIModel = (X3DObject) *io_pXSIModel;

	if((wcscmp(l_XSIModel.GetType().GetWideString(), L"#model") == 0))
	{
		// instance model are processed into an other callback
		X3DObject XSIMaster( COMMANDS::GetMaster( l_XSIModel.GetFullName() ) );

		if (!XSIMaster.IsValid())
		{
			CSLModel *l_pFTKNewModel;
			CSLModel *l_pFTKParent = (CSLModel *) in_pFTKParent;

			l_pFTKNewModel = l_pFTKParent->AddModel();
			*io_pFTKModel = l_pFTKNewModel;
			l_pFTKNewModel->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
		}
	}	

	return status;
}

wchar_t *CModelFromXSI::GetClassID(){return L"CModelFromXSI";}


/**************************************************************************************
CModelToXSI
**************************************************************************************/
CModelToXSI::CModelToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CModelToXSI::~CModelToXSI() {};

CStatus CModelToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	
	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;
	if(!l_pFTKModel->Primitive() && (l_pFTKModel != in_pContext->ftkscene()->Root()))
	{
		X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
		Model		l_XSIModel;

		_XSI_CALL(l_XSIParent.AddModel(CRefArray(), CString(L"unknown"), l_XSIModel), L"Failed to add a Model object");
		*io_pXSIModel = l_XSIModel;

		l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_XSIModel));
	}
	
	// we add a marker to flip back the base pose on export
	if(IsZUp(in_pContext->ftkscene()->CoordinateSystem()) && !strcmp(l_pFTKModel->GetName(), "MAXSceneRoot"))
	{
		CSLUserDataBlob* l_pUserData = l_pFTKModel->AddUserDataBlob();
		l_pUserData->SetName("Z_UP");
	}


	return status;
}

wchar_t *CModelToXSI::GetClassID(){return L"CModelToXSI";}


