//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_null.cpp
/*!
	implementation file for null related classes
*/

#include "stdafx.h"
#include "cnv_null.h"
#include <xsi_application.h>
#include <xsi_x3dobject.h>
#include <xsi_null.h>
#include <Null.h>
#include <Model.h>


/**************************************************************************************
CNullFromXSI
**************************************************************************************/
CNullFromXSI::CNullFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CNullFromXSI::~CNullFromXSI() {};

CStatus CNullFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	X3DObject XSIModel = (X3DObject) *io_pXSIModel;

	if(	(wcscmp(XSIModel.GetType().GetWideString(), L"SpotInterest") == 0))
	{
		// we do not process this node, the callback caller will have to make sure not
		// to process anything after this.
		status = CStatus::False;
	}
	else if(	(wcscmp(XSIModel.GetType().GetWideString(), L"SpotRoot") == 0) || 
				(wcscmp(XSIModel.GetType().GetWideString(), L"CameraRoot") == 0) || 
				(wcscmp(XSIModel.GetType().GetWideString(), L"CameraInterest") == 0) || 
				(wcscmp(XSIModel.GetType().GetWideString(), L"null") == 0))
	{
		CSLModel *l_pNewNull;
		CSLModel *l_pParent = (CSLModel *) in_pFTKParent;
	
		l_pNewNull = l_pParent->AddNull();
		*io_pFTKModel = l_pNewNull;
		l_pNewNull->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
	}	

	return status;
}

wchar_t *CNullFromXSI::GetClassID(){return L"CNullFromXSI";}

/**************************************************************************************
CUnknownFromXSI
**************************************************************************************/
CUnknownFromXSI::CUnknownFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CUnknownFromXSI::~CUnknownFromXSI() {};

CStatus CUnknownFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	X3DObject XSIModel = (X3DObject) *io_pXSIModel;

	if(	*io_pFTKModel == NULL)
	{
		//
		// Do not export a null as replacement to a texture support. This
		// would pollute the dotXSI for no good.
		// UDEV00181356

		if((wcscmp(XSIModel.GetType().GetWideString(), L"Texture Support") == 0))
		{
			return CStatus::False;
		}

		CSLModel *l_pNewUnknown;
		CSLModel *l_pParent = (CSLModel *) in_pFTKParent;

		l_pNewUnknown = l_pParent->AddNull();
		*io_pFTKModel = l_pNewUnknown;
		l_pNewUnknown->AttachUserData("CREF", in_pContext->AddCRef(*io_pXSIModel));
	}	

	return status;
}

wchar_t *CUnknownFromXSI::GetClassID(){return L"CUnknownFromXSI";}

/**************************************************************************************
CNullToXSI
**************************************************************************************/
CNullToXSI::CNullToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CNullToXSI::~CNullToXSI() {};

CStatus CNullToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	
	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;
	if(l_pFTKModel->Primitive() && (l_pFTKModel->Primitive()->Type() == CSLTemplate::SI_NULL_OBJECT))
	{
		X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
		Null		l_XSINull;

		_XSI_CALL(l_XSIParent.AddNull(CString(L"unknown"), l_XSINull), L"Failed to add a Null object");
		*io_pXSIModel = l_XSINull;

		l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_XSINull));
	}
	
	return status;
}

wchar_t *CNullToXSI::GetClassID(){return L"CNullToXSI";}


/**************************************************************************************
CUnknownToXSI
**************************************************************************************/
CUnknownToXSI::CUnknownToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CUnknownToXSI::~CUnknownToXSI() {};

CStatus CUnknownToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;

	// note: we do note import the FTK scene root.
	if( !io_pXSIModel->IsValid() && (l_pFTKModel != in_pContext->ftkscene()->Root()))
	{
		X3DObject	l_XSIParent = (X3DObject) in_XSIParent;
		Null		l_XSINull;

		_XSI_CALL(l_XSIParent.AddNull(CString(L"unknown"), l_XSINull), L"Failed to add a Null object");
		*io_pXSIModel = l_XSINull;

		l_pFTKModel->AttachUserData("CREF", in_pContext->AddCRef(l_XSINull));
	}

	return status;
}

wchar_t *CUnknownToXSI::GetClassID(){return L"CUnknownToXSI";}
