//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_plottedanimation.cpp
/*!
	animation plotting services
*/

#include "stdafx.h"
#include "cnv_plottedanimation.h"
#include "FTKUtil.h"
#include <xsi_parameter.h>
#include <xsi_fcurve.h>
#include <algorithm>

#ifdef min
# undef min
#endif

#ifdef max
# undef max
#endif


/**************************************************************************************
CAnimationPlotter
**************************************************************************************/
CAnimationPlotter::CAnimationPlotter() {};

CAnimationPlotter::~CAnimationPlotter()
{
	LONG loop;

	for (loop = 0; loop < m_ParameterTable.GetUsed(); loop++)
	{
		delete (m_ParameterTable[loop]);
	}
}

CStatus CAnimationPlotter::Execute(CdotXSIConverter *in_pContext)
{
	CStatus status = CStatus::OK;
	int loop, count = m_ParameterTable.GetUsed();

	if(count == 0)
		return status;
	
	CParameterRefArray params = in_pContext->exportproperty().GetParameters();
	
	LONG l_PlotStartFrame = params.GetValue(L"PlotStartFrame");
	LONG l_PlotEndFrame = params.GetValue(L"PlotEndFrame");
	LONG l_PlotStepFrame = params.GetValue(L"PlotStepFrame");
	LONG l_PlotInterpolation = params.GetValue(L"PlotInterpolation");
	bool l_PlotFit = params.GetValue(L"PlotFit");
	bool l_PlotProcessRotation = params.GetValue(L"PlotProcessRotation");
	float l_PlotFitTolerance = params.GetValue(L"PlotFitTolerance");
	bool l_PlotAnimation = params.GetValue(L"PlotAnimation");

	siFCurveInterpolation	l_InterpolationList[4] = 
	{
		siDefaultInterpolation,
		siConstantInterpolation,
		siLinearInterpolation,
		siCubicInterpolation 
	};

	int l_NumberOfFrames =  ((l_PlotEndFrame - l_PlotStartFrame)/l_PlotStepFrame);
	int l_NumberOfKeysToEvaluate = count * l_NumberOfFrames;
	int	l_BatchSize = std::max(1, count / std::max(1, l_NumberOfKeysToEvaluate / 2000000));

	int		l_Offset = 0;
	int		l_FCurveCount = count;

	// Here we extract the Verbose parameter
	CValue l_VerboseValue = params.GetValue(L"Verbose");

	// We are trying to optimize plotting so that the memory consumption is relatively low (at least 
	// having less chances to page fault on 1gig systems). We basically chunk the plotting by
	// 2000000 (parameters*frames). This gives us a good ratio of speed/memory

	bool	l_bProgressBarVisible = l_VerboseValue;
	if(l_NumberOfKeysToEvaluate < 30000)
		l_bProgressBarVisible = false;

	if (l_PlotAnimation == false && l_FCurveCount > 0 && l_VerboseValue == true)
	{
		logmessage(L"Fcurves plotted using the Animation Resampling settings.");
	}

	while(l_FCurveCount > 0)
	{
		CParameterRefArray l_ParameterArray;
		int l_NbCurvesToEvaluate = std::min( l_FCurveCount, l_BatchSize );

		// let's build the list of parameters to plot
		for(loop = 0; loop < l_NbCurvesToEvaluate; loop++)
		{
			l_ParameterArray.Add(m_ParameterTable[loop + l_Offset]->m_XSIParameter);

			if(l_PlotAnimation == false && l_VerboseValue == true)
			{
				logmessage(L"Plotting fcurve : %s", m_ParameterTable[loop + l_Offset]->m_XSIParameter.GetFullName().GetWideString()); 
			}
			else
			{
#ifdef _DEBUG
				logmessage(L"Plotting fcurve : %s\n", m_ParameterTable[loop + l_Offset]->m_XSIParameter.GetFullName().GetWideString());
				// Fcurves plotted using the Animation Plotting settings.
#endif
			}
		}

		if(l_VerboseValue == true)
		{
			logmessage(L"Plotting fcurves (%d-%d/%d)", l_Offset+1, (l_Offset+l_NbCurvesToEvaluate-1)+1, count); 
		}

		// now invoke the plot
		CRefArray l_PlottedFCurves = l_ParameterArray.PlotAnimation
		(
			l_PlotStartFrame,								// start frame
			l_PlotEndFrame,								// end frame
			l_PlotStepFrame,								// step
			siDefaultFCurve,												// fcurve type
			l_InterpolationList[l_PlotInterpolation],		// interpolation type
			l_PlotFit,									// fit values
			(float) l_PlotFitTolerance/100.0f,					// fit tolerance
			(bool) l_PlotProcessRotation,						// process rotations
			l_bProgressBarVisible											// progress bar visibility
		);
		
		// and convert the resulting fcurves to dotXSI
		for(loop = 0; loop < l_NbCurvesToEvaluate; loop++)
		{
			FCurve l_XSIFCurve = (FCurve) l_PlottedFCurves[loop];
			if(l_XSIFCurve.IsValid())
			{
				bool l_bProcess = true;
				if(l_XSIFCurve.GetNumKeys() == 2)
				{
					if(l_XSIFCurve.GetKeyAtIndex(0).GetValue() == l_XSIFCurve.GetKeyAtIndex(1).GetValue())
						l_bProcess = false;
				}

				if(l_bProcess)
				{
					FTKUFCurveFromXSI
					(
						m_ParameterTable[loop + l_Offset]->m_pFTKFCurveOwner,
						m_ParameterTable[loop + l_Offset]->m_FTKFCurveType,
						l_XSIFCurve,
						NULL,
						m_ParameterTable[loop + l_Offset]->m_FTKFCurveName
					);
				}
			}
		}

		l_Offset += l_NbCurvesToEvaluate;
		l_FCurveCount -= l_NbCurvesToEvaluate;
	}

	return status;
}

wchar_t *CAnimationPlotter::GetClassID(){return L"CAnimationPlotter";}

CSIBCArray<CAnimationPlotterParameterEntry*>&CAnimationPlotter::GetParameterTable()
{	
	return m_ParameterTable;
}
SI_Void CAnimationPlotter::Add ( CAnimationPlotterParameterEntry* in_pEntry)
{
	LONG loop;
	for (loop=0;loop<m_ParameterTable.GetUsed();loop++)
	{
		if ( m_ParameterTable[loop]->m_XSIParameter == in_pEntry->m_XSIParameter )
			return;
	}

	m_ParameterTable.Add ( in_pEntry );
}
