//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_ShapeAnimation.cpp
/*!
	implementation file for ShapeAnimation related classes
*/

#include "stdafx.h"
#include "cnv_shapeanimation.h"
#include <xsi_application.h>
#include <xsi_x3dobject.h>
#include <xsi_shapeclip.h>
#include <xsi_polygonmesh.h>
#include <xsi_primitive.h>
#include <xsi_geometryaccessor.h>
#include <xsi_meshbuilder.h>
#include <xsi_shapekey.h>
#include <xsi_clusterpropertybuilder.h>
#include <xsi_model.h>
#include <xsi_time.h>
#include <xsi_cluster.h>

#include <Model.h>
#include <XSIGeometry.h>
#include <XSIShapeAnimation.h>
#include <XSIShape.h>
#include <FCurve.h>

#include <string>

#include "cmdstubs.h"

/**************************************************************************************
CShapeAnimationFromXSI
**************************************************************************************/
CShapeAnimationFromXSI::CShapeAnimationFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CShapeAnimationFromXSI::~CShapeAnimationFromXSI() {};

CStatus CShapeAnimationFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	X3DObject XSIModel = (X3DObject) *io_pXSIModel;
	SceneItem XSISceneItem = (SceneItem)XSIModel;

	CTime l_Time;

	CRefArray l_KeyList;
	LONG l_lKeyCount;

	// validate some SDK objects
	if ( !XSISceneItem.IsValid()  )
		return CStatus::Fail;

	// are we dealing with a mesh? if not, exit.
	if(!(*io_pFTKModel) || (wcscmp(XSIModel.GetType().GetWideString(), L"polymsh") != 0))
		return CStatus::OK;

	PolygonMesh	l_XSIOriginalMesh = (PolygonMesh) XSIModel.GetActivePrimitive().GetGeometry();
	if ( !l_XSIOriginalMesh.IsValid() )
		return status;

	// get the semantic layer model of the mesh
	CSLModel* l_SLMesh = (CSLModel *) *io_pFTKModel;

	CSLTemplate::ETemplateType l_Type = l_SLMesh->Primitive()->Type();
	if ( l_Type != CSLTemplate::XSI_MESH)
		return status;

	CSLXSIGeometry* l_pMesh = (CSLXSIGeometry*)l_SLMesh->Primitive();

	// get the geometry accessor
	CGeometryAccessor	l_XSIOriginalMeshAccessor;
	CSIBCUserData *l_pUserData = l_pMesh->FindUserData("GEOMETRYACCESSOR");
	if(l_pUserData)
	{
		CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
		l_XSIOriginalMeshAccessor = (CGeometryAccessor) *l_pCRef;
	} else {

		// this is terrible
		logmessage ( L"Error exporting shape animation: Geometry Accessor not found for mesh %s.", XSIModel.GetName());
		return CStatus::Fail;
	}

	// Get the Shape Animation option from the export menu
	Property exportProp = in_pContext->exportproperty();
	LONG ShapeAnimType = exportProp.GetParameterValue(L"ShapeAnim");

	if (ShapeAnimType == SHAPEKEY_ONLY)
	{
		l_KeyList = l_XSIOriginalMeshAccessor.GetShapeKeys();
		l_lKeyCount = l_KeyList.GetCount();

		if (l_lKeyCount <= 0)
		{
			return CStatus::OK;	// their is not shape key on this model, nothing to do.
		}
	}
	// model using shape animation?
	else if ( !XSIModel.IsAnimated( siShapeAnimationSource ) )
	{
		return CStatus::OK;	// model not using shape anim.
	}

	//
	// get subd settings
	//
	bool l_bApplySubdivisionToGeometry = exportProp.GetParameterValue(L"ApplySubdivisionToGeometry");

	LONG l_SubdivisionLevel = 0;
	LONG l_SubdivisionRule = 0;
	bool l_bUseLoopForTriangles = false;

	if (l_bApplySubdivisionToGeometry)
	{
		// get the current subdivision option for this mesh
		Property l_Geomapprox = XSIModel.GetProperties().GetItem(L"Geometry Approximation");

		if (l_Geomapprox.IsValid())
		{
			l_SubdivisionLevel = l_Geomapprox.GetParameterValue(L"gapproxmosl");
		}

		l_SubdivisionRule = COMMANDS::GetValue(XSIModel.GetFullName() + CString(L".polymsh.subdrule"), l_Time.GetTime());
		l_bUseLoopForTriangles = COMMANDS::GetValue(XSIModel.GetFullName() + CString(L".polymsh.subdloop"), l_Time.GetTime());
	}

	CSLXSIShapeAnimation* l_pShapeAnim = l_pMesh->CreateXSIShapeAnimation(CSLTemplate::SI_LINEAR);

	//
	// convert all ShapeKeys to object reference mode
	//
	Application app;

	if ( ShapeAnimType == SHAPEKEY_ONLY )	// ShapeKey Only
	{
		// export all shape clips
	
		for (LONG c=0;c<l_lKeyCount;c++)
		{

			ShapeKey l_Clip = (ShapeKey)l_KeyList[c];
			
			LONG l_lSize = l_Clip.GetValueSize();
			CFloatArray l_Positions;
			l_Clip.GetValues ( l_Positions );
			LONG nbElements = l_Positions.GetCount();

			CSLXSIShape *l_pCurrentShape = l_pShapeAnim->AddXSIShape();
			CSLXSISubComponentAttributeList* l_pVertexList = l_pCurrentShape->AddVertexPositionList();

			CSLXSISubComponentAttributeList::CSLFloatArray *l_pFTKPositionList = l_pVertexList->GetAttributeArray();

			std::string morphTargetName = (char*)l_Clip.GetName().GetAsciiString();

			// XSI likes to add '_ShapeKey' to the end of morph target names - strip it off if it's there.
			std::string unwantedSuffix = "_ShapeKey";
			if (morphTargetName.find(unwantedSuffix) == morphTargetName.size() - unwantedSuffix.size())
				morphTargetName = morphTargetName.substr(0, morphTargetName.size() - unwantedSuffix.size());
			l_pVertexList->SetName((char*)morphTargetName.c_str());

			for (LONG i=0;i<(nbElements / (l_lSize > 0 ? l_lSize : 1));i++)
			{
				float x = l_Positions[i*3];
				float y = l_Positions[(i*3)+1];
				float z = l_Positions[(i*3)+2];

				if ( ( fabs(x) > EPSILON ) || 
					( fabs(y) > EPSILON ) || 
					( fabs(z) > EPSILON ))
				{
					l_pFTKPositionList->Add ( (float)i );
					l_pFTKPositionList->Add ( x );
					l_pFTKPositionList->Add ( y );
					l_pFTKPositionList->Add ( z );

				}
			}
			
		}
	}

	if ( ShapeAnimType == PLOT_SHAPES )	// Plot Shape Animation
	{
		Application app;
		XSI::CValue startframe;
		XSI::CValue endframe;

		Property playControl = app.GetActiveProject().GetProperties().GetItem(L"Play Control");
		startframe = playControl.GetParameterValue(L"in");
		endframe = playControl.GetParameterValue(L"out" );

		CDoubleArray l_OriginalPositionArray;
		l_XSIOriginalMeshAccessor.GetVertexPositions(l_OriginalPositionArray);

		// add an animation fcurve that drives the shape animation
		CSLFCurve* l_pFCurve = l_pShapeAnim->AddAnimation ();
		l_pFCurve->GetLinearKeyList()->Resize((LONG)((float)endframe-(float)startframe)+1);

		LONG ii=0;
		for (int k=(int)((float)startframe);k< (int) ((float)(endframe)+1.0f);k++)
		{
			// evaluate the mesh at the current frame
			PolygonMesh			l_XSIMesh = (PolygonMesh) XSIModel.GetActivePrimitive().GetGeometry((float)k);
			if ( !l_XSIMesh.IsValid() )
				return CStatus::Fail;

			// Get the geometry approximation properties
			Property l_Geomapprox = XSIModel.GetProperties().GetItem(L"Geometry Approximation");
				
			// grab the discontinuity properties for this mesh
			bool   l_bAutoDiscontinuity = true;
			double l_DiscontinuityAngle = 60.0;

			if (l_Geomapprox.IsValid())
			{
				// if object has it's own copy of these properties
				l_bAutoDiscontinuity = l_Geomapprox.GetParameterValue(L"gapproxmoad");
				l_DiscontinuityAngle = l_Geomapprox.GetParameterValue(L"gapproxmoan");
			}

			// create a geometry accessor for the mesh at the current frame
			CGeometryAccessor	l_XSIMeshAccessor;
			l_XSIMeshAccessor = l_XSIMesh.GetGeometryAccessor(siConstructionModeAnimation,
															 (siSubdivisionRuleType)l_SubdivisionRule,
															 l_SubdivisionLevel,
															 l_bUseLoopForTriangles,
															 l_bAutoDiscontinuity,
															 l_DiscontinuityAngle);

			// output a shape key
			CDoubleArray l_PositionArray;
			l_XSIMeshAccessor.GetVertexPositions(l_PositionArray);

			LONG nbElements = l_PositionArray.GetCount();

			CSLXSIShape *l_pCurrentShape = l_pShapeAnim->AddXSIShape();
			CSLXSISubComponentAttributeList* l_pVertexList = l_pCurrentShape->AddVertexPositionList();

			char l_szFullShapeKey[MAX_PATH];
			sprintf ( l_szFullShapeKey, "ShapeKey%d", k );

			CSLXSISubComponentAttributeList::CSLFloatArray *l_pFTKPositionList = l_pVertexList->GetAttributeArray();
			l_pVertexList->Template()->InstanceName().SetText(l_szFullShapeKey);

			for (LONG i=0;i<(nbElements / 3);i++)
			{
				float x = (float)l_PositionArray[i*3];
				float y = (float)l_PositionArray[(i*3)+1];
				float z = (float)l_PositionArray[(i*3)+2];

				float ox = (float)l_OriginalPositionArray[i*3];
				float oy = (float)l_OriginalPositionArray[(i*3)+1];
				float oz = (float)l_OriginalPositionArray[(i*3)+2];

				if ( ( fabs(x-ox) > EPSILON ) || 
					( fabs(y-oy) > EPSILON ) || 
					( fabs(z-oz) > EPSILON ) )
				{
					l_pFTKPositionList->Add ( (float)i );
					l_pFTKPositionList->Add ( x-ox );
					l_pFTKPositionList->Add ( y-oy );
					l_pFTKPositionList->Add ( z-oz );

				}
			}		

			(*l_pFCurve->GetLinearKeyList())[ii].m_fTime = (float)k;
			(*l_pFCurve->GetLinearKeyList())[ii].m_fValue = (float)ii;
			ii++;
		}

	}

	return status;
}

wchar_t *CShapeAnimationFromXSI::GetClassID(){return L"CShapeAnimationFromXSI";}

/**************************************************************************************
CShapeAnimationToXSI
**************************************************************************************/
CShapeAnimationToXSI::CShapeAnimationToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CShapeAnimationToXSI::~CShapeAnimationToXSI() {};

CStatus CShapeAnimationToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	CString l_csShapeKey(L"Shape");
	CSLModel *l_pFTKModel = (CSLModel *) *io_pFTKModel;

	if ( !l_pFTKModel->Primitive () )
		return status;

	if ( l_pFTKModel->Primitive ()->Type () != CSLTemplate::XSI_MESH )
		return status;

	X3DObject XSIModel = (X3DObject) *io_pXSIModel;

	CSLXSIGeometry* l_pMesh = (CSLXSIGeometry*)l_pFTKModel->Primitive();

	CSLXSIShapeAnimation* l_pShapeAnim = l_pMesh->XSIShapeAnimation ();

	if ( !l_pShapeAnim )
		return status;

	// change the progress bar title since this can take a while
	in_pContext->SetProgressBarSubtitle ( L"Processing ShapeAnimation");

	LONG l_lShapeCount = l_pShapeAnim->GetXSIShapeCount ();
	
	PolygonMesh polymesh = XSIModel.GetActivePrimitive().GetGeometry(); 
	CClusterPropertyBuilder cpBuilder = polymesh.GetClusterPropertyBuilder(); 
	Application app;

	CSLFCurve* l_pShapeAnimAnimation = l_pShapeAnim->Animation ();

	for (LONG i=0;i<l_lShapeCount;i++)
	{
        CSLXSIShape* l_pShape = l_pShapeAnim->XSIShapes ()[i];
		CSLXSISubComponentAttributeList* l_pSLPositionList = l_pShape->GetVertexPositionList();
		CSLXSISubComponentAttributeList::CSLFloatArray* l_pSLPositions = l_pSLPositionList->GetAttributeArray();

		// Get names to match existing model
		CString l_EndNameOfExistingModel( L"_ShapeKey" ); // might be followed with a number (xsi unique name)
		CString l_ShapeName;
		l_ShapeName.PutAsciiString( l_pSLPositionList->GetName() );
		
		// Find existing FTK model
		CSLModel* l_pExistingModel = NULL;
		CStringArray l_SplitName = l_ShapeName.Split(l_EndNameOfExistingModel);
		if ( (l_SplitName.GetCount() > 0) && (l_SplitName[0] != l_ShapeName) )
		{
			CString l_NameMeshToFind = l_SplitName[0];
			l_pExistingModel = in_pContext->ftkscene()->FindModelRecursively( (char*)l_NameMeshToFind.GetAsciiString(), in_pContext->ftkscene()->Root() );
		}

		// Find existing XSI model
		CRef* l_pExistingModelCRef = NULL;
		if (l_pExistingModel)
		{
			l_csShapeKey = l_ShapeName;

			CSIBCUserData *l_pModelUserData = l_pExistingModel->FindUserData("CREF");
			if (l_pModelUserData)
			{
				l_pExistingModelCRef = (CRef*)(l_pModelUserData->GetData());
			}
		}

		if (l_pExistingModelCRef)
		{
			//
			// Create a shapekey from existing object (just link)

			// Get the user instancing mode
			CString l_PreferenceShapeInstanceMode(L"preferences.shape_animation.ShapeInstancingMode");
			int l_OldPreferenceShapeInstanceMode = COMMANDS::GetValue(l_PreferenceShapeInstanceMode, CValue(0.0f));

			// Set the proper instancing mode
			COMMANDS::SetValue(l_PreferenceShapeInstanceMode, CValue(1), CValue(0.0f));

			// Create the link
			X3DObject l_XSIExistingModel = (X3DObject) *l_pExistingModelCRef;

			CValueArray args(5);
			CValue retval;
			LONG b(0);

			args[b++]= XSIModel;
			args[b++]= l_XSIExistingModel;
			args[b++]= CValue(XSI::siShapeObjectReferenceMode);
			args[b++]= L"True";
			args[b++]= L"True";

			app.ExecuteCommand( L"SelectShapeKey", args, retval );

			// Reset to the user instancing mode
			COMMANDS::SetValue(l_PreferenceShapeInstanceMode, CValue(l_OldPreferenceShapeInstanceMode), CValue(0.0f)); // mut be 1
		}
		else
		{
			//
			// Create a new shapekey

			CString l_csInstanceName(l_pShape->Template()->InstanceName().GetText());
			ShapeKey XSIShapeKey = cpBuilder.AddShapeKey(XSI::siShapeObjectReferenceMode, l_csShapeKey, l_csShapeKey );

			l_pShape->AttachUserData("CREF", in_pContext->AddCRef(XSIShapeKey));

			XSIShapeKey.PutName(l_ShapeName);

			LONG l_lSize = XSIShapeKey.GetValueSize();
			CFloatArray l_Positions;
			XSIShapeKey.GetValues ( l_Positions );
			LONG nbElements = l_Positions.GetCount();

			if (l_pShape->GetShapeType() == CSLXSIShape::XSI_INDEXED)
			{
				float*	l_pNewArray = new float [nbElements];
				// zero the array
				for (LONG z=0;z<nbElements;z++)
					l_pNewArray[z] = 0.0f;

				// copy the array
				LONG l_iCount = l_pSLPositions->GetUsed();

				for (LONG c=0;c<l_iCount/4;c++)
				{
					LONG l_iIndex = (LONG)l_pSLPositions->ArrayPtr ()[c*4];

					if((l_iIndex*3+2) < nbElements)
					{
						l_pNewArray[l_iIndex*3] = l_pSLPositions->ArrayPtr ()[(c*4)+1];
						l_pNewArray[(l_iIndex*3)+1] = l_pSLPositions->ArrayPtr ()[(c*4)+2];
						l_pNewArray[(l_iIndex*3)+2] = l_pSLPositions->ArrayPtr ()[(c*4)+3];
					}
					else
					{
						CString l_Message;
						l_Message.PutAsciiString(l_pFTKModel->GetName());
						l_Message += L" has an invalid shape: the number of vertices on the shape is greater than the number of vertices on the mesh";
						logmessage((wchar_t *)l_Message.GetWideString(), siError);
					}
				}

				XSIShapeKey.SetValues ( l_pNewArray, nbElements / (l_lSize > 0 ? l_lSize : 1));
				delete l_pNewArray;
			}
			else
			{
				XSIShapeKey.SetValues ( l_pSLPositions->ArrayPtr (), nbElements / (l_lSize > 0 ? l_lSize : 1));
			}

			// any fcurve driving the shape animation?
			if ( l_pShapeAnimAnimation )
			{
				// apply the shape keys to the mixer
				for (int f=0;f<l_pShapeAnimAnimation->GetLinearKeyList ()->GetUsed();f++)
				{
					if ( (LONG)((*l_pShapeAnimAnimation->GetLinearKeyList())[f].m_fValue) == i)
					{
						CValueArray args(4);
						CValue retval;
						LONG b(0);

						args[b++]= XSIShapeKey;
						args[b++]= L"";
						args[b++]= L"";
						args[b++]= CValue((LONG)(*l_pShapeAnimAnimation->GetLinearKeyList())[f].m_fTime);

						app.ExecuteCommand( L"ApplyShapeKey", args, retval );
					}
				}
			} 
		}
	}

	return status;
}

wchar_t *CShapeAnimationToXSI::GetClassID(){return L"CShapeAnimationToXSI";}

