//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_userdatablob.cpp
/*!
	implementation file for user data blob conversion
*/

#include "stdafx.h"
#include "cnv_userdatablob.h"
#include <XSIUserData.h>
#include <xsi_userdatablob.h>
#include <xsi_siobject.h>
#include <xsi_actionsource.h>
#include <xsi_clip.h>
#include <xsi_material.h>
#include <xsi_sceneitem.h>
#include <xsi_shader.h>
#include <xsi_source.h>
#include <xsi_property.h>

/**************************************************************************************
CUserDataBlobFromXSI
**************************************************************************************/
CUserDataBlobFromXSI::CUserDataBlobFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CUserDataBlobFromXSI::~CUserDataBlobFromXSI() {};

CStatus CUserDataBlobFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	int loop, count;	

	CRefArray l_XSIProperties;

	ActionSource l_XSIActionSource = (ActionSource) *io_pXSIModel;
	Clip l_XSIClip = (Clip) *io_pXSIModel;
	Material l_XSIMaterial = (Material) *io_pXSIModel;
	SceneItem l_XSISceneItem = (SceneItem) *io_pXSIModel;
	Shader l_XSIShader = (Shader) *io_pXSIModel;
	Source l_XSISource = (Source) *io_pXSIModel;

	if(l_XSIActionSource.IsValid()) 
		l_XSIProperties = l_XSIActionSource.GetProperties();
	else if(l_XSIClip.IsValid())
		l_XSIProperties = l_XSIClip.GetProperties();
	else if(l_XSIMaterial.IsValid()) 
		l_XSIProperties = l_XSIMaterial.GetProperties();
	else if(l_XSISceneItem.IsValid()) 
		l_XSIProperties = l_XSISceneItem.GetProperties();
	else if(l_XSIShader.IsValid()) 
		l_XSIProperties = l_XSIShader.GetProperties();
	else if(l_XSISource.IsValid()) 
		l_XSIProperties = l_XSISource.GetProperties();

	if(l_XSIProperties.IsValid())
	{
		count = l_XSIProperties.GetCount();
		for(loop = 0;loop < count;loop++)
		{
			Property l_XSIProperty = (Property) l_XSIProperties[loop];
			if(l_XSIProperty.GetType() == CString(L"UserDataBlob"))
			{
				const unsigned char	*l_pValue;
				unsigned int	l_Size;

				UserDataBlob l_XSIUserDataBlob = (UserDataBlob) l_XSIProperty;
				CString l_UserDataName = l_XSIUserDataBlob.GetName();

				// would be good to use a skip list in the future

				if(l_UserDataName != L"Z_UP")
				{
					CSLUserDataBlob *l_pFTKUserDataBlob = (*io_pFTKModel)->AddUserDataBlob();
					char* l_szName = (char *) (l_UserDataName.GetAsciiString());
					l_pFTKUserDataBlob->SetName(l_szName);
					l_XSIUserDataBlob.GetValue(l_pValue, l_Size);
					l_pFTKUserDataBlob->GetUserData()->Extend(l_Size);

					unsigned int loop2;
					for(loop2 = 0; loop2 < l_Size; loop2++)
					{
						(*l_pFTKUserDataBlob->GetUserData())[loop2] = l_pValue[loop2];
					}
				}
				else
				{
					in_pContext->ftkscene()->Root()->AttachUserData("Z_UP", NULL);
				}
			}
		}
	}
	else
	{
		status = CStatus::False;
	}

	return status;
}

wchar_t *CUserDataBlobFromXSI::GetClassID(){return L"CUserDataBlobFromXSI";}

/**************************************************************************************
CUserDataBlobToXSI
**************************************************************************************/
CUserDataBlobToXSI::CUserDataBlobToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CUserDataBlobToXSI::~CUserDataBlobToXSI() {};

CStatus CUserDataBlobToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;
	CSLTemplate *l_pTemplate = *io_pFTKModel;

	if(l_pTemplate != NULL)
	{
		SIObject l_XSIObject = (SIObject) *io_pXSIModel;
		if(l_XSIObject.IsValid())
		{
			ActionSource l_XSIActionSource = (ActionSource) *io_pXSIModel;
			Clip l_XSIClip = (Clip) *io_pXSIModel;
			Material l_XSIMaterial = (Material) *io_pXSIModel;
			SceneItem l_XSISceneItem = (SceneItem) *io_pXSIModel;
			Shader l_XSIShader = (Shader) *io_pXSIModel;
			Source l_XSISource = (Source) *io_pXSIModel;
			
			int loop, count;
			count = l_pTemplate->GetUserDataBlobCount();
			for(loop = 0; loop < count; loop++)
			{
				CSLUserDataBlob *l_pUserDataBlob = l_pTemplate->GetUserDataBlobList()[loop];
				Property	l_XSIProperty;
				CString		l_UserDataBlobName;
				
				l_UserDataBlobName.PutAsciiString(l_pUserDataBlob->GetName());

				if(l_XSIActionSource.IsValid()) 
					l_XSIProperty = l_XSIActionSource.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);
				else if(l_XSIClip.IsValid())
					l_XSIProperty = l_XSIClip.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);
				else if(l_XSIMaterial.IsValid()) 
					l_XSIProperty = l_XSIMaterial.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);
				else if(l_XSISceneItem.IsValid()) 
					l_XSIProperty = l_XSISceneItem.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);
				else if(l_XSIShader.IsValid()) 
					l_XSIProperty = l_XSIShader.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);
				else if(l_XSISource.IsValid()) 
					l_XSIProperty = l_XSISource.AddProperty(CString(L"UserDataBlob"), false, l_UserDataBlobName);

				if(l_XSIProperty.IsValid())
				{
					UserDataBlob l_XSIUserDataBlob = (UserDataBlob) l_XSIProperty;
					l_XSIUserDataBlob.PutValue(l_pUserDataBlob->GetUserDataPtr(), l_pUserDataBlob->GetUserDataSize());
				}
			}
		}
		else
		{
			status = CStatus::False;
		}
	}

	return status;
}

wchar_t *CUserDataBlobToXSI::GetClassID(){return L"CUserDataBlobToXSI";}

