#include "stdafx.h"
#include "dotXSIConverter.h"
#include "plugin_stub.h"
#include <xsi_application.h>
#include <xsi_context.h>
#include <xsi_menu.h>
#include <xsi_property.h>
#include <xsi_model.h>
#include <xsi_command.h>
#include <xsi_argument.h>
#include <xsi_ppglayout.h>
#include <xsi_time.h>
#include <xsi_parameter.h>
#include <xsi_ppgeventcontext.h>
#include <xsi_selection.h>
#include <xsi_uitoolkit.h>
#include <xsi_griddata.h>
#include <xsi_color.h> 

#include <xsi_material.h>
#include <xsi_shader.h>
#include <xsi_kinematics.h>
#include <xsi_imageclip.h>
#include <xsi_actionsource.h>
#include <xsi_mixer.h>
#include <xsi_materiallibrary.h>
#include <xsi_preferences.h>
#include <xsi_null.h>
#include <xsi_geometry.h>
#include <xsi_primitive.h>
#include <xsi_polygonmesh.h>
#include <xsi_geometryaccessor.h>

// Modules
#include "cnv_dotXSI_IO.h"
#include "cnv_COLLADA_IO.h"
#include "cnv_info.h"
#include "cnv_environment.h"
#include "cnv_hierarchytraversal.h"
#include "cnv_model.h"
#include "cnv_null.h"
#include "cnv_modelinfo.h"
#include "cnv_camera.h"
#include "cnv_custompset.h"
#include "cnv_material.h"
#include "cnv_image.h"
#include "cnv_instance.h"
#include "cnv_mesh.h"
#include "cnv_mesh_clusterprop.h"
#include "cnv_mesh_cluster.h"
#include "cnv_light.h"
#include "cnv_camera_anim.h"
#include "cnv_custompset_anim.h"
#include "cnv_environment_anim.h"
#include "cnv_material_anim.h"
#include "cnv_light_anim.h"
#include "cnv_modelinfo_anim.h"
#include "cnv_image_anim.h"
#include "cnv_mixer.h"
#include "cnv_userdatablob.h"
#include "cnv_plottedanimation.h"
#include "cnv_envelope.h"
#include "cnv_shapeanimation.h"
#include "cnv_hierarchyelementinfo.h"
#include "cnv_ik.h"

#include <commdlg.h>

#include "check.h"
#include "rc.h"
#include "helper.h"

#include "Properties.h"

/****************************************************************************************
XSI plugin Command definition functions
****************************************************************************************/
_XSI_EXTERN_ CStatus CryExportCrosswalk_Init( const CRef& in_context )
{
	CStatus status = CStatus::OK;
	Context ctx(in_context);
	Command cmd(ctx.GetSource());

	cmd.EnableReturnValue( true ) ; 

	// See xsi_command.h and xsi_argument.h for further
	// attributes you may wish to set. For example Command.PutTooltip(),
	// and ArgumentArray.AddWithHandler()	

	Application app;

	// Configure this code based on the number of arguments
	// you want.  You can also specific default values for these arguments.

	ArgumentArray args = cmd.GetArguments();
	args.Add( L"arg0", L"\0" );

	return status;
}

/****************************************************************************************
XSI plugin menu event functions
****************************************************************************************/
_XSI_EXTERN_ CStatus CryExport_Execute( CRef& in_ref )
{
	CStatus status = CStatus::OK;
	Application app;

	Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CryExportCrosswalkOptions" ) ;

	if (!prop.IsValid())
	{
		prop = app.GetActiveSceneRoot().AddProperty( L"CryExportCrosswalkOptions" ) ;
	}

	// Let's build our label for the property page
	wchar_t l_wLabel[1024];
	swprintf(l_wLabel,
#ifdef unix
		sizeof(l_wLabel),
		L"Crosswalk Export v%ls build %s %s",
#else
		L"Crosswalk Export v%s build %S %S",
#endif
		TOOL_VERSION, __DATE__, __TIME__);

	XSI::COMMANDS::InspectObj(L"CryExportCrosswalkOptions",CValue(),l_wLabel,(LONG)siRecycle,false);

	return status;
}

_XSI_EXTERN_ CStatus CryExport_Init( CRef& in_ref )
{
	CStatus status = CStatus::OK;

	Context ctxt = in_ref;
	Menu menu = ctxt.GetSource();

	CStatus st;
	MenuItem item;

	// Here we add our menu item in the export menu
	menu.AddCallbackItem(L"CryExport", L"CryExport_Execute", item);

	return status;
}

_XSI_EXTERN_ CStatus CryExportAll_Execute( CRef& in_ref )
{
	CStatus status = CStatus::OK;
	Application app;

	Property prop = app.GetActiveSceneRoot().GetProperties().GetItem( L"CryExportCrosswalkOptions" ) ;

	if (!prop.IsValid())
	{
		prop = app.GetActiveSceneRoot().AddProperty( L"CryExportCrosswalkOptions" ) ;
	}

	CValue			retValue;
	CValueArray		args(1);

	/////////////////////////////////////////////////////////////////////////
	// Update the filenames
	/////////////////////////////////////////////////////////////////////////
	CValue l_Value;
	CString l_FolderPath = GetExportPath();
	l_FolderPath += L"\\";

	Scene l_Scene = app.GetActiveProject().GetActiveScene();
	CString l_FullFilename = l_Scene.GetParameterValue(L"Filename");
	CStringArray l_FullFilenameSplit = l_FullFilename.Split( L"\\");
	const char *l_pFilename = l_FullFilenameSplit[l_FullFilenameSplit.GetCount()-1].GetAsciiString();

	CString l_Filename = l_FolderPath;

	if (l_pFilename && strlen(l_pFilename) > 4)
	{
		char *l_pTemp = _strdup(l_pFilename);
		CString l_Temp;
		l_pTemp[strlen(l_pTemp)-4] = NULL;

		l_Temp.PutAsciiString(l_pTemp);

		l_Filename += l_Temp;
		l_Filename += L".dae";
	}

	prop.PutParameterValue(L"Filename", l_Filename);

	// For the sake of simplicity here the command takes an CryExportCrosswalkOptions property
	// as its only parameter
	args[0] = prop.GetFullName();
	prop.PutParameterValue(L"Type",(short)EXPORT_ALL);

	if (Diagnostics(false))
	{
		app.ExecuteCommand(L"CryExportCrosswalk", args, retValue);
		RunResourceCompiler(l_Filename, true);
	}

	return status;
}

_XSI_EXTERN_ CStatus CryExportCrosswalk_Execute( CRef& in_context )
{
	CStatus status = CStatus::OK;
	Application app;
	Context ctxt(in_context);
	int loop;

	UnhideAllClusters();

	/* NO IK PRESERVATION
	bool l_bPreserveIK;
	*/
	CAnimationPlotter *l_pAnimationPlotter = NULL;
	CMaterialLibraryFromXSI *l_pMatLibConverter = NULL;

	// Access the arguments to the command
	CValueArray		args = ctxt.GetAttribute( L"Arguments" );
	CString			argName(args[0]);
	debugprintf(L"Cry Crosswalk Export - Using %s\n", argName.GetWideString());

	// Create our converter and export
	CdotXSIConverter converter;

	// Set the export property here
	_XSI_CALL(converter.SetExportProperty(argName), L"Failed to set export properties");

	CProcessTimer::ResetTasks();

	Property exportProp = converter.exportproperty();
	LONG l_lFormat = exportProp.GetParameterValue(L"Format");
	converter.SetFormat(l_lFormat);

	short l_lType = exportProp.GetParameterValue(L"Type");

	l_CryExportNodesToExport.Clear();

	if (l_lType == EXPORT_SUBSET)
	{
		CString l_StringCryExportNodeList = exportProp.GetParameterValue(L"CryExportNodeList");

		if (l_StringCryExportNodeList.Length() == 0)
		{
			app.LogMessage(L"You must specify the CryExportNode(s) - Export Subset was canceled", siErrorMsg);
			return CStatus::Fail;
		}
		else
		{
			CStringArray l_SplitList = l_StringCryExportNodeList.Split(L";");

			if (!l_SplitList.GetCount())
			{
				app.LogMessage(L"You must select a CryExportNode(s) - Export Subset was canceled", siErrorMsg);
				return CStatus::Fail;
			}

			for (loop = 0; loop < l_SplitList.GetCount(); loop++)
			{
				CString l_CryExportNodeName = l_SplitList[loop];
				CStringArray l_CryExportNodeNameSplit = l_CryExportNodeName.Split(L":");

				if (l_CryExportNodeNameSplit.GetCount() == 1)
				{
					X3DObject l_Object = GetCryExportNodeByName(l_SplitList[loop]);
					l_CryExportNodesToExport.Add(l_Object);

					// set the ExportFiletype to the Filetype
					CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
					l_Properties.PutParameterValue(L"ExportFiletype", GetCryExportNodeFiletype(l_Object));
				}
				else
				{
					short l_ExportFiletype = 0;
					X3DObject l_Object = GetCryExportNodeByName(l_CryExportNodeNameSplit[0]);

					// check if the next entry is the same node with CAF or ANM type
					if (loop+1 < l_SplitList.GetCount())
					{
						CString l_CryExportNodeName2 = l_SplitList[loop+1];
						CStringArray l_CryExportNode2NameSplit = l_CryExportNodeName2.Split(L":");

						if (l_CryExportNodeNameSplit.GetCount() > 1)
						{
							if (l_CryExportNode2NameSplit[0] == l_CryExportNodeNameSplit[0])
							{
								// we found two, set the ExportFiletype to CHR and CAF or CGA and ANM
								if (l_CryExportNode2NameSplit[1] == L"CHR" || l_CryExportNode2NameSplit[1] == L"CAF")
									l_ExportFiletype = CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF;
								else if (l_CryExportNode2NameSplit[1] == L"CGA" || l_CryExportNode2NameSplit[1] == L"ANM")
									l_ExportFiletype = CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_ANM;
							}
						}
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CHR")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CHR;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CAF")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CAF;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"CGA")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_CGA;
					}

					// set the ExportFiletype to the filetype specified in the string
					if (l_CryExportNodeNameSplit[1] == L"ANM")
					{
						l_ExportFiletype |= CRY_FILE_TYPE_ANM;
					}

					CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
					l_Properties.PutParameterValue(L"ExportFiletype", (short)l_ExportFiletype);

					l_CryExportNodesToExport.Add(l_Object);

					// skip the next one if we found the two file type entry
					if (l_ExportFiletype == (CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF))
					{
						loop++;
					}
					if (l_ExportFiletype == (CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_ANM))
					{
						loop++;
					}
				}
			}
		}
	}
	else if(l_lType == EXPORT_ALL)
	{
		l_CryExportNodesToExport = GetAllCryExportNodes();

		for (LONG i = 0; i < l_CryExportNodesToExport.GetCount(); i++)
		{
			X3DObject l_Object(l_CryExportNodesToExport.GetItem(i));

			CustomProperty l_Properties(l_Object.GetProperties().GetItem(L"ExportProperties"));
			l_Properties.PutParameterValue(L"ExportFiletype", GetCryExportNodeFiletype(l_Object));
		}

		if (l_CryExportNodesToExport.GetCount() == 0)
		{
			app.LogMessage(L"There is no CryExportNodes in the scene - Export All was canceled", siErrorMsg);
			return status;
		}
	}

	// This is where we populate the list of export callbacks

	// if something is selected then check the advance option
	exportProp = converter.exportproperty();
	bool l_bExportSelectionOnly = exportProp.GetParameterValue(L"ExportSelectionOnly");


	// This callback sets the version of dotXSI to export
	converter.exportcallbacks().Add(new CProcessTimer(L"Set version"));
	converter.exportcallbacks().Add(new CdotXSI_SetVersion());

	// This callback sets scene information from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting scene info"));
	converter.exportcallbacks().Add(new CSceneInfoFromXSI());

	/* NO ENVIRONEMENT EXPORT
	// This callback sets the environment (ambience) from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting environment"));
	converter.exportcallbacks().Add(new CEnvironmentFromXSI());
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting environment animations"));
	converter.exportcallbacks().Add(new CEnvironmentAnimationFromXSI());
	*/

	// This callback sets the image clips from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting image clips"));
	converter.exportcallbacks().Add(new CXSIImageLibraryFromXSI());

	/*
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting image clip animations"));
	converter.exportcallbacks().Add(new CXSIImageLibraryAnimationFromXSI());
	*/
	// This callback sets the materials from XSI to the FTK
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting materials"));
	l_pMatLibConverter = new CMaterialLibraryFromXSI(l_lType);
	converter.exportcallbacks().Add(l_pMatLibConverter);
	/*
	converter.exportcallbacks().Add(new CProcessTimer(L"Converting material animations"));
	converter.exportcallbacks().Add(new CMaterialLibraryAnimationFromXSI());
	*/

	// if we export everything we do not need to filter based on selection.
	// This callback does a first hierarchy travers to identify which scene elements
	// we want to export exactly (based on selection).
	CXSIHierarchyTraverser *l_XSIFilteringPassTraverser = new CXSIHierarchyTraverser();

	// we are not setting the mode of this pass to selected so it will go thru all the
	// element of the scene and will execute the callback regardless of the Filetype.
	CHierarchyElementInfoFromXSI *l_pFilterCallbak = new CHierarchyElementInfoFromXSI(CRY_FILE_TYPE_NONE);
	l_pFilterCallbak->SetCryExportNodesToExport(l_CryExportNodesToExport);

	l_XSIFilteringPassTraverser->callbacks().Add(l_pFilterCallbak);
	converter.exportcallbacks().Add(new CProcessTimer(L"Filtering pass"));
	converter.exportcallbacks().Add(l_XSIFilteringPassTraverser);

	// This callback adds auxiliary nodes to the list to export.
	CXSIHierarchyTraverser *l_XSIAuxiliaryPassTraverser = new CXSIHierarchyTraverser();

	// we are not setting the mode of this pass to selected so it will go thru all the
	// element of the scene and will execute the callback regardless of the Filetype.
	CAuxiliaryHierarchyElementInfoFromXSI *l_pAuxiliaryCallback = new CAuxiliaryHierarchyElementInfoFromXSI(CRY_FILE_TYPE_NONE);
	l_pAuxiliaryCallback->SetAuxiliaryNodesToExport(l_pFilterCallbak->GetAuxiliaryNodesToExport(), l_pFilterCallbak->GetAuxiliaryNodeFileTypes());

	l_XSIAuxiliaryPassTraverser->callbacks().Add(l_pAuxiliaryCallback);
	converter.exportcallbacks().Add(new CProcessTimer(L"Auxiliary pass"));
	converter.exportcallbacks().Add(l_XSIAuxiliaryPassTraverser);

	// Add the Root hierarchy element info.
	converter.AddHierarchyElementInfo();

	// This callback makes a traverser to populate models in the FTK from XSI (Pass1)
	CXSIHierarchyTraverser *l_XSIPass1Traverser = new CXSIHierarchyTraverser();

	l_XSIPass1Traverser->SetTraverserMode( l_bExportSelectionOnly ? CXSIHierarchyTraverser::SELECTED : CXSIHierarchyTraverser::ALL );

	converter.exportcallbacks().Add(new CProcessTimer(L"Converting hierarchy - first pass"));
	converter.exportcallbacks().Add(l_XSIPass1Traverser);

	if (l_lType != EXPORT_ALLMATERIALS)
	{
		// CrySpecific: Remove ModelFromXSI...
		//	l_XSIPass1Traverser->callbacks().Add(new CModelFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF));
		l_XSIPass1Traverser->callbacks().Add(new CNullFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));

		/* NO CAMERAS AND NO LIGHTS
		if (l_lType == EXPORT_TYPE_ALL)
		{
		if (( l_lFormat == DOTXSI_FORMAT_5_0 ) || ( l_lFormat == DOTXSI_FORMAT_5_0_BINARY ))
		{
		l_XSIPass1Traverser->callbacks().Add(new CCameraFromXSI());
		}
		else
		{
		l_XSIPass1Traverser->callbacks().Add(new CXSI_CameraFromXSI());
		}

		l_XSIPass1Traverser->callbacks().Add(new CLightFromXSI());
		}
		*/

		/* NO INSTANCES
		l_XSIPass1Traverser->callbacks().Add(new CInstanceFromXSI());
		*/
		l_XSIPass1Traverser->callbacks().Add(new CMeshFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		l_XSIPass1Traverser->callbacks().Add(new CMeshClusterPropFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		/* NO IK PRESERVATION
		l_bPreserveIK = exportProp.GetParameterValue(L"PreserveIK");

		if ( (l_lFormat != COLLADA_FORMAT_1_4_1) && (l_bPreserveIK) )
		{
		l_XSIPass1Traverser->callbacks().Add(new CIKFromXSI());
		}
		*/
		l_XSIPass1Traverser->callbacks().Add(new CUnknownFromXSI(CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_ANM));

		l_XSIPass1Traverser->callbacks().Add(new CHierarchyUpdateFTKModel(CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_ANM));
		l_XSIPass1Traverser->callbacks().Add(new CUserDataBlobFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		l_XSIPass1Traverser->callbacks().Add(new CModelInfoFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));
		l_XSIPass1Traverser->callbacks().Add(new CCustomPSetFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		// now let's just add our animation callbacks 

		// create our master animation plotter if we want to globally plot animation
		l_pAnimationPlotter = new CAnimationPlotter();

		/* NO CAMERA AND NO LIGHT
		CCameraAnimationFromXSI				*l_pCameraAnimation = new CCameraAnimationFromXSI();
		CXSICameraAnimationFromXSI			*l_pXSICameraAnimation = new CXSICameraAnimationFromXSI();
		CLightAnimationFromXSI				*l_pLightAnimation = new CLightAnimationFromXSI();
		*/
		CCustomPSetAnimationFromXSI			*l_pCustomPSetAnimation = new CCustomPSetAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);
		CModelInfoAnimationFromXSI			*l_pModelInfoAnimation = new CModelInfoAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);
		CGlobalTransformAnimationFromXSI	*l_pGlobalTransformAnimation = new CGlobalTransformAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA);

		bool l_bPlotAnimation = exportProp.GetParameterValue(L"PlotAnimation");

		if (l_bPlotAnimation) // global animation plotting
		{
			/* NO CAMERA AND NO LIGHT
			l_pCameraAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pXSICameraAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pLightAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			*/

			l_pCustomPSetAnimation->SetAnimationPlotter(l_pAnimationPlotter);
			l_pModelInfoAnimation->SetAnimationPlotter(l_pAnimationPlotter);
		}

		l_pGlobalTransformAnimation->SetAnimationPlotter(l_pAnimationPlotter);

		/* NO CAMERA AND NO LIGHT
		l_XSIPass1Traverser->callbacks().Add(l_pCameraAnimation);
		l_XSIPass1Traverser->callbacks().Add(l_pXSICameraAnimation);	
		l_XSIPass1Traverser->callbacks().Add(l_pLightAnimation);
		l_XSIPass1Traverser->callbacks().Add(l_pCustomPSetAnimation);
		*/

	// CrySpecific: Only mixer animations
//		l_XSIPass1Traverser->callbacks().Add(l_pModelInfoAnimation);
//		l_XSIPass1Traverser->callbacks().Add(l_pGlobalTransformAnimation);
		l_XSIPass1Traverser->callbacks().Add(new CMixerFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CAF|CRY_FILE_TYPE_ANM));

		l_XSIPass1Traverser->callbacks().Add(new CShapeAnimationFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

	}

	CXSIInstanceDataFromXSI *l_pInstanceDataConverter = new CXSIInstanceDataFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR);
	l_pInstanceDataConverter->m_pMatLibConverter = l_pMatLibConverter;
	l_XSIPass1Traverser->callbacks().Add(l_pInstanceDataConverter);

	// Pass 2 - Create new traverser that connects operators or other
	// things that have relations between objects
	CXSIHierarchyTraverser *l_XSIPass2Traverser = new CXSIHierarchyTraverser();
	l_XSIPass2Traverser->SetTraverserMode( l_bExportSelectionOnly ? CXSIHierarchyTraverser::SELECTED : CXSIHierarchyTraverser::ALL );

	converter.exportcallbacks().Add(new CProcessTimer(L"Converting hierarchy - second pass"));
	converter.exportcallbacks().Add(l_XSIPass2Traverser);

	if (l_lType != EXPORT_ALLMATERIALS)
	{
		l_XSIPass2Traverser->callbacks().Add(new CMeshClusterFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));

		// in shape animation "plot all animation" mode, we do not export the envelope operator since the
		// envelope deformation is plotted.
		LONG l_ShapeAnimType = exportProp.GetParameterValue(L"ShapeAnim");

		if ( l_ShapeAnimType != CShapeAnimationFromXSI::PLOT_SHAPES )
		{
			l_XSIPass2Traverser->callbacks().Add(new CEnvelopeFromXSI(CRY_FILE_TYPE_CGF|CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_CHR));
		}

		/* NO IK PRESERVATION
		if (l_lType == EXPORT_TYPE_ALL && !l_bPreserveIK)
		{
		CIKtoFKFromXSI						*l_pIKtoFK = new CIKtoFKFromXSI();
		l_pIKtoFK->SetAnimationPlotter(l_pAnimationPlotter);
		l_XSIPass2Traverser->callbacks().Add(l_pIKtoFK);
		}
		*/

		// Optimizers phase
		converter.exportcallbacks().Add(new CProcessTimer(L"Plotting animations"));
		converter.exportcallbacks().Add(l_pAnimationPlotter);

		converter.exportcallbacks().Add(new CMaterialLibraryFromXSI_RemoveUnused());
		converter.exportcallbacks().Add(new CXSIImageLibraryFromXSI_RemoveUnused());

	}

	// This is where we populate the list of write callbacks
	// This callback writes the content of the FTK as a dotXSI
	converter.writecallbacks().Add(new CProcessTimer(L"Writing file"));

	if ( l_lFormat == COLLADA_FORMAT_1_4_1 )
	{
		converter.writecallbacks().Add(new CCOLLADA_Write());
	} else {
		converter.writecallbacks().Add(new CdotXSI_Write());
	}

	converter.writecallbacks().Add(new CProcessTimer(L"Export completed"));

	// Converts the XSI scene to dotXSI
	CProcessTimer::Reset();
	_XSI_CALL(converter.ConvertFromXSI(), L"Failed to convert scene");

	if (!converter.IsCancelPressed())
	{    
		// Write the file
		_XSI_CALL(converter.Write(), L"Failed to write");
	}

	HideClusters();

	return status;
}

/****************************************************************************************
XSI plugin custom properties function
****************************************************************************************/
_XSI_EXTERN_ CStatus CryExportCrosswalkOptions_Define( const CRef & in_Ctx )
{
	CStatus status = CStatus::OK;
	Application app ;
	CustomProperty prop = Context(in_Ctx).GetSource() ;
	Parameter param ;

	// Default capabilities for most of these parameters
	int caps = siPersistable;
	CValue dft ;	// Used for arguments we don't want to set


	// ================================================================================
	// File
	// ================================================================================

	// CrySpecific: Set Format to COLLADA: 1
	dft = (LONG)1;
	prop.AddParameter(	L"Format",CValue::siString, caps,
		L"Format", L"",
		dft, param ) ;

	prop.AddParameter(	L"Format",CValue::siUInt4 , caps, 
		L"Format", L"", 
		dft, param ) ;	

	param.PutValue(CValue((LONG)1L));




	Project l_XSIProject = app.GetActiveProject();
	CString l_FileName = l_XSIProject.GetPath();

#ifdef unix
	l_FileName += L"/dotXSI/default.xsi";
#else
	l_FileName += L"\\dotXSI\\default.xsi";
#endif

	if ( gOldPath.IsEmpty() )
	{
		CString l_FileName = l_XSIProject.GetPath();
		l_FileName += L"\\dotXSI\\";
		param.PutValue(l_FileName);
	} else {
		param.PutValue(gOldPath);
	}

	// ================================================================================
	// Advanced
	// ================================================================================
	prop.AddParameter(	L"Verbose",CValue::siBool, caps,
		L"Verbose", L"",
		dft, param ) ;
	param.PutValue(CValue(true));

	prop.AddParameter(	L"ExportXSIExtra",CValue::siBool, caps,
		L"ExportXSIExtra", L"",
		dft, param ) ;
	// CrySpecific: Set ExportXSIExtra to false
	param.PutValue(CValue(false));

	prop.AddParameter(	L"ExportSelectionOnly",CValue::siBool, caps, 
		L"ExportSelectionOnly", L"", 
		dft, param ) ;	
	// CrySpecific: Set ExportSelectionOnly to true
	param.PutValue(CValue(true));

	// ================================================================================
	// Geometry 
	// ================================================================================
	prop.AddParameter(	L"ApplySubdivisionToGeometry",CValue::siBool, caps, 
		L"ApplySubdivisionToGeometry", L"", 
		dft, param ) ;	
	param.PutValue(CValue(false));

	prop.AddParameter(	L"Triangulate",CValue::siBool, caps, 
		L"Triangulate", L"", 
		dft, param ) ;	
	// CrySpecific: Set Triangulate to true
	param.PutValue(CValue(true));
	param.PutCapabilityFlag( siReadOnly, true );

	prop.AddParameter(	L"ExportTangentsAsVtxColor",CValue::siBool, caps, 
		L"ExportTangentsAsVtxColor", L"", 
		dft, param ) ;	
	param.PutValue(CValue(false));

	// ================================================================================
	// Shape animation
	// ================================================================================
	prop.AddParameter(	L"ShapeAnim",CValue::siUInt4 , caps, 
		L"Shapes", L"", 
		dft, param ) ;	
	param.PutValue(CValue((LONG)CShapeAnimationFromXSI::SHAPEKEY_ONLY));


	// ================================================================================
	// Plot animation
	// ================================================================================
	prop.AddParameter(	L"PlotAnimation",CValue::siBool, caps, 
		L"PlotAnimation", L"", 
		dft, param ) ;	
	// CrySpecific: Set PlotAnimation to true
	param.PutValue(CValue(false));

	// get the starting frame from XSI
	CTime time;
	float startframe;
	startframe = COMMANDS::GetValue(CString(L"PlayControl.In"), time.GetTime());

	// get the ending frame from XSI
	float endframe;
	endframe = COMMANDS::GetValue(CString(L"PlayControl.Out"), time.GetTime());

	prop.AddParameter(	L"PlotStartFrame",CValue::siInt4, caps, 
		L"PlotStartFrame", L"", 
		dft, param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );
	param.PutValue(CValue((LONG)startframe));

	prop.AddParameter(	L"PlotEndFrame",CValue::siInt4, caps, 
		L"PlotEndFrame", L"", 
		dft, param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );
	param.PutValue(CValue((LONG)endframe));

	prop.AddParameter(	L"PlotStepFrame",CValue::siInt4, caps, 
		L"PlotStepFrame", L"", 
		dft, param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );
	param.PutValue(CValue((LONG)1));

	prop.AddParameter(	L"PlotInterpolation",CValue::siInt1, caps, 
		L"PlotInterpolation", L"", 
		dft, param ) ;	
	// CrySpecific: Set PlotInterpolation to Constant: 1
	param.PutValue(CValue((LONG)1));

	prop.AddParameter(	L"PlotFit",CValue::siBool, caps, 
		L"PlotFit", L"", 
		dft, param ) ;	
	param.PutValue(CValue(true));

	prop.AddParameter(	L"PlotFitTolerance",CValue::siFloat, caps, 
		L"PlotFitTolerance", L"", 
		dft, param ) ;	

	param.PutValue(CValue(1.0f));

	prop.AddParameter(	L"PlotProcessRotation",CValue::siBool, caps, 
		L"PlotProcessRotation", L"", 
		dft, param ) ;	
	param.PutValue(CValue(true));

	prop.AddParameter(	L"ExportXSINormals",CValue::siBool, caps, 
		L"ExportXSINormals", L"", 
		dft, param ) ;	
	// CrySpecific: Set ExportXSINormals to Constant: true
	param.PutValue(CValue(true));

	// ================================================================================
	// IK
	// ================================================================================
	prop.AddParameter(	L"PreserveIK",CValue::siBool, caps, 
		L"PreserveIK", L"", 
		dft, param ) ;	
	param.PutValue(CValue(false));

	// ================================================================================
	// Paths
	// ================================================================================
	prop.AddParameter(	L"PathRelative",CValue::siBool, caps, 
		L"PathRelative", L"", 
		dft, param ) ;	
	param.PutValue(CValue(false));

	// ================================================================================
	// CryExport
	// ================================================================================
	prop.AddParameter(	L"CryExportNodeList",CValue::siString, caps,
		L"CryExportNodeList", L"",
		L"", param ) ;

	prop.AddParameter(	L"FilenameSubset",CValue::siString , caps, 
		L"FilenameSubset", L"", 
		L"", param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );

	prop.AddParameter(	L"FilenameAll",CValue::siString , caps, 
		L"FilenameAll", L"", 
		L"", param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );

	prop.AddParameter(	L"Filename",CValue::siString , caps, 
		L"Filename", L"", 
		L"", param ) ;	
	param.PutCapabilityFlag( siReadOnly, true );

	prop.AddParameter(	L"Type",CValue::siUInt4 , caps, 
		L"Type", L"", 
		dft, param ) ;	

	return status;
}

CStatus CryExportCrosswalkOptions_RebuildLayout(PPGLayout &in_Layout, CustomProperty &in_CustomProp)
{
	CStatus status = CStatus::OK;
	PPGItem item ;

	in_Layout.Clear();	

	// ================================================================================
	// General plugin description string
	// ================================================================================
	wchar_t l_wLabel[1024];
	swprintf(l_wLabel, L"%d.%d (%S, %S)", VERSION_MAJOR, VERSION_MINOR, __DATE__, __TIME__);
	CString l_CrosswalkVersionNumber(CROSSWALK_VERSION_NUMBER);
	CString l_Version(L"CryExport ");
	CString l_CrosswalkVersion(L"Based on Crosswalk ");
	l_Version += l_wLabel;
	l_CrosswalkVersion += l_CrosswalkVersionNumber;

	in_Layout.AddGroup();
	in_Layout.AddRow();
	in_Layout.AddStaticText(l_Version);
	in_Layout.EndRow();
	in_Layout.AddRow();
	in_Layout.AddStaticText(l_CrosswalkVersion);
	in_Layout.EndRow();
	in_Layout.EndGroup();

	// ================================================================================
	// CryExportNodes List
	// ================================================================================
	CValueArray l_CryExportNodeList;
	CRefArray l_AllCryExportNodes = GetAllCryExportNodes();

	int loop;

	for (loop = 0; loop < l_AllCryExportNodes.GetCount(); loop++)
	{
		X3DObject l_Object(l_AllCryExportNodes.GetItem(loop));

		l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object));
		l_CryExportNodeList.Add(l_Object.GetName());
	}

	in_Layout.AddGroup(L"CryExportNodes");
	item = in_Layout.AddEnumControl( L"CryExportNodeList", l_CryExportNodeList, L"", siControlListBox ) ;
	item.PutAttribute( siUIMultiSelectionListBox, true );
	item.PutAttribute( siUICY, (LONG)200 ) ;
	item.PutAttribute( siUIStyle, (LONG)0x10200101 ) ;
	//	item.PutAttribute( siUIStyle, (LONG)0x0101 ) ;
	item.PutAttribute( siUINoLabel, true ) ;
	item = in_Layout.AddButton(L"Refresh", L"Refresh");
	in_Layout.EndGroup();

	// ================================================================================
	// The Export button
	// ================================================================================
	in_Layout.AddGroup(L"");
	item = in_Layout.AddButton(L"ExportSubset", L"Export Subset");
	item = in_Layout.AddString(L"FilenameSubset",L"File Name");
	in_Layout.EndGroup();

	// ================================================================================
	// The Export All button
	// ================================================================================
	in_Layout.AddGroup(L"");
	item = in_Layout.AddButton(L"ExportAll", L"Export All");
	item = in_Layout.AddString(L"FilenameAll",L"File Name");
	in_Layout.EndGroup();

	// ================================================================================
	// Note
	// ================================================================================
	in_Layout.AddGroup(L"");
	in_Layout.AddStaticText(L"Note: To change the destination folder, edit");
	in_Layout.AddStaticText(L"the Crytek preferences via the Crytek menu.");
	in_Layout.EndGroup();

	// ================================================================================
	// help
	// ================================================================================
	//in_Layout.PutAttribute( siUIHelpFile, L"<FactoryPath>/Doc/<DocLangPref>/XSI/xsidocs.chm::/menubar20.htm");

	return status;
}

_XSI_EXTERN_ CStatus CryExportCrosswalkOptions_DefineLayout( const CRef & in_Ctx )
{
	CStatus status = CStatus::OK;

	// XSI will call this to define the visual appearance of the CustomProperty
	// The layout is shared between all instances of the CustomProperty
	// and is cached.  You can force the code to re-execute by using the 
	// XSIUtils.Refresh feature.

	PPGLayout oLayout = Context( in_Ctx ).GetSource() ;

	CustomProperty cusProp;
	status = CryExportCrosswalkOptions_RebuildLayout(oLayout, cusProp);

	return status;
}

_XSI_EXTERN_ CStatus CryExportCrosswalkOptions_PPGEvent( const CRef& io_Ctx )
{
	CStatus status = CStatus::OK;
	// This callback is called when events happen in the user interface
	// This is where the "logic" code is implemented.

	Application app ;

	PPGEventContext ctx( io_Ctx ) ;

	PPGEventContext::PPGEvent eventID = ctx.GetEventID() ;

	if ( eventID == PPGEventContext::siParameterChange )
	{		
		// For this event the Source of the event is the parameter
		// itself
		Parameter changed = ctx.GetSource() ;	

		CustomProperty prop = changed.GetParent() ;	

		CString   paramName = changed.GetScriptName() ; 

		bool l_bPlot = prop.GetParameterValue( L"PlotAnimation" );
		bool l_bFit = prop.GetParameterValue( L"PlotFit" );

		Parameter start = prop.GetParameters().GetItem( L"PlotStartFrame" ) ;
		Parameter end = prop.GetParameters().GetItem( L"PlotEndFrame" ) ;
		Parameter step = prop.GetParameters().GetItem( L"PlotStepFrame" ) ;
		Parameter tolerance = prop.GetParameters().GetItem( L"PlotFitTolerance" ) ;

		if ( paramName == L"PlotAnimation" )
		{
			start.PutCapabilityFlag( siReadOnly, !l_bPlot );
			end.PutCapabilityFlag( siReadOnly, !l_bPlot );
			step.PutCapabilityFlag( siReadOnly, !l_bPlot );
		}
		if ( paramName == L"PlotFit" )
		{
			tolerance.PutCapabilityFlag( siReadOnly, !l_bFit);
		}
		if ( paramName == L"Format" )
		{
			PPGLayout oPPGLayout = prop.GetPPGLayout();		

			CryExportCrosswalkOptions_RebuildLayout(oPPGLayout, prop);

			//Redraw the PPG to show the new combo items
			ctx.PutAttribute(L"Refresh",true);
		}
		if ( paramName == L"Target" )
		{
			PPGLayout oPPGLayout = prop.GetPPGLayout();		

			CryExportCrosswalkOptions_RebuildLayout(oPPGLayout, prop);

			//Redraw the PPG to show the new combo items
			ctx.PutAttribute(L"Refresh",true);
		}
	}
	else if ( eventID == PPGEventContext::siButtonClicked )
	{
		CustomProperty prop = ctx.GetSource();

		CValue l_ButtonName = ctx.GetAttribute( L"Button" );

		if (l_ButtonName.GetAsText() == L"ExportSubset")
		{
			CValue			retValue;
			CValueArray		args(1);

			CString l_Filename = prop.GetParameterValue(L"FilenameSubset");

			prop.PutParameterValue(L"Filename", l_Filename);

			// For the sake of simplicity here the command takes an CryExportCrosswalkOptions property
			// as its only parameter
			args[0] = prop.GetFullName();
			prop.PutParameterValue(L"Type",(short)EXPORT_SUBSET);

			if (Diagnostics(false))
			{
				if (app.ExecuteCommand(L"CryExportCrosswalk", args, retValue) == CStatus::OK)
					RunResourceCompiler(l_Filename, true);
			}
		}
		else if (l_ButtonName.GetAsText() == L"ExportAll")
		{
			CValue			retValue;
			CValueArray		args(1);

			CString l_Filename = prop.GetParameterValue(L"FilenameAll");

			prop.PutParameterValue(L"Filename", l_Filename);

			// For the sake of simplicity here the command takes an CryExportCrosswalkOptions property
			// as its only parameter
			args[0] = prop.GetFullName();
			prop.PutParameterValue(L"Type",(short)EXPORT_ALL);

			if (Diagnostics(false))
			{
				if (app.ExecuteCommand(L"CryExportCrosswalk", args, retValue) == CStatus::OK)
					RunResourceCompiler(l_Filename, true);
			}
		}
		else if (l_ButtonName.GetAsText() == L"http://softimage.wiki.avid.com/index.php/Category:Crosswalk")
		{
			CValue			retValue;
			CValueArray		args(1);

			// For the sake of simplicity here the command takes an CryExportCrosswalkOptions property
			// as its only parameter
			args[0] = L"http://softimage.wiki.avid.com/index.php/Category:Crosswalk";

			app.ExecuteCommand(L"OpenNetView", args, retValue);
		}
		else if (l_ButtonName.GetAsText() == L"Refresh")
		{
			eventID = PPGEventContext::siOnInit;
		}
	}
	if( eventID == PPGEventContext::siOnInit )
	{
		CustomProperty prop = ctx.GetSource() ;
		PPGLayout oPPGLayout = prop.GetPPGLayout();		
		PPGItem oPPGItem;

		/////////////////////////////////////////////////////////////////////////
		// Update the CryExportNode list
		/////////////////////////////////////////////////////////////////////////
		CValueArray l_CryExportNodeList;
		CRefArray l_AllCryExportNodes = GetAllCryExportNodes();

		int loop;

		for (loop = 0; loop < l_AllCryExportNodes.GetCount(); loop++)
		{
			X3DObject l_Object(l_AllCryExportNodes.GetItem(loop));

			if (GetCryExportNodeFiletype(l_Object) == (CRY_FILE_TYPE_CHR|CRY_FILE_TYPE_CAF))
			{
				l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object, L"CHR"));
				l_CryExportNodeList.Add(l_Object.GetName() + L":CHR");

				l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object, L"CAF"));
				l_CryExportNodeList.Add(l_Object.GetName() + L":CAF");
			}
			else if (GetCryExportNodeFiletype(l_Object) == (CRY_FILE_TYPE_CGA|CRY_FILE_TYPE_ANM))
			{
				l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object, L"CGA"));
				l_CryExportNodeList.Add(l_Object.GetName() + L":CGA");

				l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object, L"ANM"));
				l_CryExportNodeList.Add(l_Object.GetName() + L":ANM");
			}
			else
			{
				l_CryExportNodeList.Add(GetCryExportNodeListName(l_Object));
				l_CryExportNodeList.Add(l_Object.GetName());
			}
		}

		oPPGItem = oPPGLayout.GetItem(L"CryExportNodeList");
		oPPGItem.PutUIItems(l_CryExportNodeList);

		/////////////////////////////////////////////////////////////////////////
		// Update the filenames
		/////////////////////////////////////////////////////////////////////////
		CValue l_Value;
		CString l_FolderPath = GetExportPath();
		l_FolderPath += L"\\";

		Scene l_Scene = app.GetActiveProject().GetActiveScene();
		CString l_FullFilename = l_Scene.GetParameterValue(L"Filename");
		CStringArray l_FullFilenameSplit = l_FullFilename.Split( L"\\");
		const char *l_pFilename = l_FullFilenameSplit[l_FullFilenameSplit.GetCount()-1].GetAsciiString();

		CString l_Filename = l_FolderPath;
		CString l_FilenameSubset = l_FolderPath;

		if (l_pFilename && strlen(l_pFilename) > 4)
		{
			char *l_pTemp = _strdup(l_pFilename);
			CString l_Temp;
			l_pTemp[strlen(l_pTemp)-4] = NULL;

			l_Temp.PutAsciiString(l_pTemp);

			l_Filename += l_Temp;
			l_Filename += L".dae";

			l_FilenameSubset += l_Temp;
			l_FilenameSubset += L"_Subset.dae";
		}

		prop.PutParameterValue(L"FilenameSubset", l_FilenameSubset);
		prop.PutParameterValue(L"FilenameAll", l_Filename);

		//Redraw the PPG to show the new combo items
		ctx.PutAttribute(L"Refresh",true);
	}

	return status;
}

/****************************************************************************************
XSI plugin export CreateOptions Command definition functions
****************************************************************************************/
_XSI_EXTERN_ CStatus CreateCryExportCrosswalkOptions_Init( const CRef& in_context )
{
	CStatus status = CStatus::OK;
	Context ctx(in_context);
	Command cmd(ctx.GetSource());

	cmd.EnableReturnValue( true ) ; 

	// See xsi_command.h and xsi_argument.h for further
	// attributes you may wish to set. For example Command.PutTooltip(),
	// and ArgumentArray.AddWithHandler()	

	Application app;

	// Configure this code based on the number of arguments
	// you want.  You can also specific default values for these arguments.

	ArgumentArray args = cmd.GetArguments();
	args.Add( L"arg0", L"\0" );
	args.Add( L"arg1", L"CryExportCrosswalkOptions\0" );

	return status;
}

_XSI_EXTERN_ CStatus CreateCryExportCrosswalkOptions_Execute( CRef& in_context )
{
	CStatus status = CStatus::OK;
	Application app;
	Context ctxt(in_context);
	Property l_Property;

	// Access the arguments to the command
	CValueArray		args = ctxt.GetAttribute( L"Arguments" );
	CString			argObjectName(args[0]);
	CString			argOptionName(args[1]);

	if (argOptionName.IsEmpty())
	{
		argOptionName = L"CryExportCrosswalkOptions";
	}

	if (!argObjectName.IsEmpty())
	{
		X3DObject  l_XSIObject = app.GetActiveSceneRoot().FindChild(argObjectName, CString(), CStringArray() );

		if(l_XSIObject.IsValid())
		{
			l_Property = l_XSIObject.AddProperty( L"CryExportCrosswalkOptions" ) ;
		}
	}
	else
	{
		l_Property = app.GetActiveSceneRoot().AddProperty( L"CryExportCrosswalkOptions" ) ;
	}

	if (l_Property.IsValid())
	{
		l_Property.PutName(argOptionName);
	}

	CValue l_Value(l_Property);
	ctxt.PutAttribute( L"ReturnValue", l_Value );

	return status;
}
