//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file dotXSIConverter.cpp  
    Implementation file for the CdotXSIConverter class
*/

#include "stdafx.h"
#include "dotXSIConverter.h"
#include "cmdstubs.h"
#include <Angle.h>
#include <Model.h>
#include <Primitive.h>
#include <xsi_time.h>
#include <xsi_uitoolkit.h>
#include "cnv_info.h"
#include "cnv_hierarchyelementinfo.h"
#include "plugin_stub.h"

/****************************************************************************************
Locals 
****************************************************************************************/

void	gWarningCallback( SI_Char* in_szMessage , SI_Int in_iLevel);

/****************************************************************************************
Constructors/Destructors
****************************************************************************************/

CdotXSIConverter::CdotXSIConverter() :
	m_pHierarchyElementInfoRoot(NULL),
	m_pHierarchyElementInfoLast(NULL),
	m_pHierarchyElementInfoCurrent(NULL),
	m_pScene(NULL),
	m_iFormat(-1)
{
	m_Project = m_Application.GetActiveProject();
	m_Scene = m_Project.GetActiveScene();

	m_bIsCancelPressed = false;
}

void	CdotXSIConverter::SetFormat( int in_iFormat )
{
	if (( in_iFormat == DOTXSI_FORMAT_5_0 ) || ( in_iFormat == DOTXSI_FORMAT_5_0_BINARY ) || 
		( in_iFormat == DOTXSI_FORMAT_6_0 ) || ( in_iFormat == DOTXSI_FORMAT_6_0_BINARY ))
	{
		m_pScene = new CSLScene(); 
	}

	if ( in_iFormat == COLLADA_FORMAT_1_4_1 )
	{
		m_pScene = new CSLCOLLADAScene(); 
	}

	m_pScene->SetWarningCallback(gWarningCallback);

	m_iFormat = in_iFormat;
}

int		CdotXSIConverter::GetFormat()
{
	return m_iFormat;
}


CdotXSIConverter::~CdotXSIConverter()
{
	if(m_pScene != NULL)
		delete m_pScene;
	
	int loop;
	for(loop = 0; loop < m_CRefGarbageCollection.GetUsed(); loop++)
	{
		delete m_CRefGarbageCollection[loop];
	}

	ClearExportCallbacks();
	ClearImportCallbacks();
	ClearWriteCallbacks();
	ClearReadCallbacks();

	while (m_pHierarchyElementInfoRoot)
	{
		CHierarchyElementInfo* l_pInfo = m_pHierarchyElementInfoRoot;
		m_pHierarchyElementInfoRoot = m_pHierarchyElementInfoRoot->GetNext();
		delete l_pInfo;
	}
}

/****************************************************************************************
Member access
****************************************************************************************/
Application	&CdotXSIConverter::application() { return m_Application; };

Project		&CdotXSIConverter::project() { return m_Project; };

Scene		&CdotXSIConverter::scene() { return m_Scene; };

CValueArray	&CdotXSIConverter::args() { return m_Args; };

Property	&CdotXSIConverter::exportproperty() { return m_ExportProperty; };

Property	&CdotXSIConverter::importproperty() { return m_ImportProperty; };

CSLScene	*CdotXSIConverter::ftkscene() { return m_pScene; };

CSIBCArray<CdotXSIConverterCallback *>	&CdotXSIConverter::exportcallbacks() { return m_ExportCallbacks; };

CSIBCArray<CdotXSIConverterCallback *>	&CdotXSIConverter::importcallbacks() { return m_ImportCallbacks; };

CSIBCArray<CdotXSIConverterCallback *>	&CdotXSIConverter::writecallbacks() { return m_WriteCallbacks; };

CSIBCArray<CdotXSIConverterCallback *>	&CdotXSIConverter::readcallbacks() { return m_ReadCallbacks; };

CStatus	CdotXSIConverter::SetExportProperty(CString in_PropertyName)
{
	CStatus status = CStatus::OK;

	CRef ref = (CRef) COMMANDS::GetValue(in_PropertyName, CValue(0.0f));

	if(ref.IsValid())
	{
		m_ExportProperty = (Property) ref;
	}
	else
	{
		status = CStatus::Fail;
	}

	return status;
}

CStatus	CdotXSIConverter::SetImportProperty(CString in_PropertyName)
{
	CStatus status = CStatus::OK;

	CRef ref = (CRef) COMMANDS::GetValue(in_PropertyName, CValue(0.0f));

	if(ref.IsValid())
	{
		m_ImportProperty = (Property) ref;
	}
	else
	{
		status = CStatus::Fail;
	}

	return status;
}

void CdotXSIConverter::ClearExportCallbacks()
{
	int loop;

	for(loop = 0; loop < m_ExportCallbacks.GetUsed(); loop++)
	{
		CdotXSIConverterCallback *l_pCallback = m_ExportCallbacks[loop];
		if(l_pCallback != NULL)
			delete l_pCallback;
	}
}

void CdotXSIConverter::ClearImportCallbacks()
{
	int loop;

	for(loop = 0; loop < m_ImportCallbacks.GetUsed(); loop++)
	{
		CdotXSIConverterCallback *l_pCallback = m_ImportCallbacks[loop];
		if(l_pCallback != NULL)
			delete l_pCallback;
	}
}

void CdotXSIConverter::ClearWriteCallbacks()
{
	int loop;

	for(loop = 0; loop < m_WriteCallbacks.GetUsed(); loop++)
	{
		CdotXSIConverterCallback *l_pCallback = m_WriteCallbacks[loop];
		if(l_pCallback != NULL)
			delete l_pCallback;
	}
}

void CdotXSIConverter::ClearReadCallbacks()
{
	int loop;

	for(loop = 0; loop < m_ReadCallbacks.GetUsed(); loop++)
	{
		CdotXSIConverterCallback *l_pCallback = m_ReadCallbacks[loop];
		if(l_pCallback != NULL)
			delete l_pCallback;
	}
}

CRef *CdotXSIConverter::AddCRef(CRef &in_ref)
{
	m_CRefGarbageCollection.Extend(1);
	m_CRefGarbageCollection[m_CRefGarbageCollection.GetUsed()-1] = new CRef(in_ref);
	return m_CRefGarbageCollection[m_CRefGarbageCollection.GetUsed()-1];
}

CHierarchyElementInfo *CdotXSIConverter::AddHierarchyElementInfo()
{
	if (m_pHierarchyElementInfoLast)
	{
		m_pHierarchyElementInfoLast->SetNext(new CHierarchyElementInfo());
		m_pHierarchyElementInfoLast = m_pHierarchyElementInfoLast->GetNext();
	}
	else
	{
		m_pHierarchyElementInfoLast = m_pHierarchyElementInfoRoot = new CHierarchyElementInfo();
	}

	return m_pHierarchyElementInfoLast;
}

CHierarchyElementInfo*		CdotXSIConverter::GetFirstHierarchyElementInfo()
{
	m_pHierarchyElementInfoCurrent = m_pHierarchyElementInfoRoot;

	return m_pHierarchyElementInfoCurrent;
}

CHierarchyElementInfo*		CdotXSIConverter::GetNextHierarchyElementInfo()
{
	if (m_pHierarchyElementInfoCurrent)
	{
		m_pHierarchyElementInfoCurrent = m_pHierarchyElementInfoCurrent->GetNext();
	}

	return m_pHierarchyElementInfoCurrent;
}


/****************************************************************************************
Conversion methods
****************************************************************************************/

CStatus	CdotXSIConverter::ConvertFromXSI()
{
	CStatus status = CStatus::OK;

	COMMANDS::Refresh(CValue());

	int loop;
	
	m_bIsCancelPressed = false;

	CTime	l_Time;
	CValue	l_PPGProp = COMMANDS::GetValue(CString(L"preferences.Interaction.autoinspect"), l_Time.GetTime());
	COMMANDS::SetValue(CString(L"preferences.Interaction.autoinspect"), CValue(false), l_Time.GetTime());

	try
	{
		for(loop = 0; (loop < m_ExportCallbacks.GetUsed()) && (status == CStatus::OK); loop++)
		{
			if (IsCancelPressed())
			{
				logerror ( L"Operation canceled.");
				status = CStatus::False;
				break;
			}

			if(m_ExportCallbacks[loop] != NULL)
				_XSI_CALL(m_ExportCallbacks[loop]->Execute(this), L"Failed to execute export callback");
		}
	}
	catch(...)
	{
		logerror(L"dotXSIExport generated an exception");
	}

	// False just means that further processing of callbacks has aborted, but the error is
	// Not critical, we therefore just return OK after
	if(status == CStatus::False && !IsCancelPressed())
		status = CStatus::OK;

	COMMANDS::SetValue(CString(L"preferences.Interaction.autoinspect"), l_PPGProp, l_Time.GetTime());

	return status;
}


CStatus CdotXSIConverter::ConvertToXSI()
{
	CStatus status = CStatus::OK;

	COMMANDS::Refresh(CValue());

	int loop;

	CTime	l_Time;
	CValue	l_PPGProp = COMMANDS::GetValue(CString(L"preferences.Interaction.autoinspect"), l_Time.GetTime());
	COMMANDS::SetValue(CString(L"preferences.Interaction.autoinspect"), CValue(false), l_Time.GetTime());

	m_bIsCancelPressed = false;

	try
	{
		for(loop = 0; (loop < m_ImportCallbacks.GetUsed()) && (status == CStatus::OK); loop++)
		{
			if (IsCancelPressed())
			{
				logerror ( L"Operation canceled.");
				status = CStatus::False;
				break;
			}

			if(m_ImportCallbacks[loop] != NULL)
				_XSI_CALL(m_ImportCallbacks[loop]->Execute(this), L"Failed to execute import callback");
		}
	}
	catch(...)
	{
		logerror(L"dotXSIImport generated an exception");
	}

	// False just means that further processing of callbacks has aborted, but the error is
	// Not critical, we therefore just return OK after
	if(status == CStatus::False && !IsCancelPressed())
		status = CStatus::OK;

	COMMANDS::SetValue(CString(L"preferences.Interaction.autoinspect"), l_PPGProp, l_Time.GetTime());

	return status;
}


/****************************************************************************************
IO methods
****************************************************************************************/

CStatus	CdotXSIConverter::Write()
{
	CStatus status = CStatus::OK;

	int loop;
	for(loop = 0; (loop < m_WriteCallbacks.GetUsed()) && (status == CStatus::OK); loop++)
	{
		if(m_WriteCallbacks[loop] != NULL)
			_XSI_CALL(m_WriteCallbacks[loop]->Execute(this), L"Failed to execute write callback");
	}

	// False just means that further processing of callbacks has aborted, but the error is
	// Not critical, we therefore just return OK after
	if(status == CStatus::False && !IsCancelPressed())
		status = CStatus::OK;

	return status;
}


CStatus CdotXSIConverter::Read()
{
	CStatus status = CStatus::OK;

	int loop;
	for(loop = 0; (loop < m_ReadCallbacks.GetUsed()) && (status == CStatus::OK); loop++)
	{
		if(m_ReadCallbacks[loop] != NULL)
			_XSI_CALL(m_ReadCallbacks[loop]->Execute(this), L"Failed to execute read callback");
	}

	// False just means that further processing of callbacks has aborted, but the error is
	// Not critical, we therefore just return OK after
	if(status == CStatus::False && !IsCancelPressed())
		status = CStatus::OK;

	return status;
}
/****************************************************************************************
utility function
****************************************************************************************/

float	CdotXSIConverter::AngleFromFTK(float in_fAngle,bool in_bRadian)
{
	// from degree to radian
	if((m_pScene->Angle()->GetAngleType() == CSLAngle::SI_DEGREES) && (in_bRadian))
	{
		return CNV_DEGTORAD(in_fAngle);
	}

	// from radian to degree
	if((m_pScene->Angle()->GetAngleType() == CSLAngle::SI_RADIANS) && (!in_bRadian))
	{
		return CNV_RADTODEG(in_fAngle);
	}

	return in_fAngle;
}

float	CdotXSIConverter::AngleToFTK(float in_fAngle,bool in_bRadian)
{
	// from degree to radian
	if((m_pScene->Angle()->GetAngleType() == CSLAngle::SI_DEGREES) && (in_bRadian))
	{
		return CNV_RADTODEG(in_fAngle);
	}

	// from radian to degree
	if((m_pScene->Angle()->GetAngleType() == CSLAngle::SI_RADIANS) && (!in_bRadian))
	{
		return CNV_DEGTORAD(in_fAngle);
	}

	return in_fAngle;
}

CSLModel* CdotXSIConverter::FindModelByCRef ( CSLModel* in_pRootModel, CRef in_cref )
{
	//
	// Note: This function is recursive
	//

	if ( in_pRootModel == NULL )
	{
		// start from the root
		in_pRootModel = m_pScene->Root ();
	}

	// check the user data attached to this model
	CSIBCUserData *l_pModelUserData = in_pRootModel->FindUserData("CREF");
	if ( l_pModelUserData )
	{
		CRef *l_pCRef = (CRef*)(l_pModelUserData->GetData());

		if ( in_cref == (*l_pCRef))
		{
			return in_pRootModel;
		}
	}

	// recurse children list
    for (LONG c=0; c<in_pRootModel->GetChildrenCount();c++)
	{
		CSLModel* l_pRetVal = FindModelByCRef ( in_pRootModel->GetChildrenList ()[c], in_cref );
		
		if ( l_pRetVal )
			return l_pRetVal;
	}

	// no luck
	return NULL;
}

void CdotXSIConverter::SetProgressBarSubtitle( CString in_Subtitle )
{
	if ( m_ExportCallbacks.GetUsed() )
	{
		CProcessTimer* l_pTimer = (CProcessTimer*)(m_ExportCallbacks[0]);
		l_pTimer->ShowSubtitle ( in_Subtitle );
	}

	if ( m_ImportCallbacks.GetUsed() )
	{
		CProcessTimer* l_pTimer = (CProcessTimer*)(m_ImportCallbacks[0]);
		l_pTimer->ShowSubtitle ( in_Subtitle );
	}
}

void CdotXSIConverter::SetCancelPressed(bool in_bCancelPressed)
{
	m_bIsCancelPressed = in_bCancelPressed;
}

bool CdotXSIConverter::IsCancelPressed()
{
	Application app;

	m_bIsCancelPressed |= app.GetUIToolkit().GetProgressBar().IsCancelPressed();

	return m_bIsCancelPressed;
}

/****************************************************************************************
dotXSI converter utility function
****************************************************************************************/

void debugprintf(wchar_t *in_pFormat, ...)
{
#ifdef _DEBUG
	Application app;

	wchar_t	tmpBuffer[4096];
    va_list vl;

	va_start( vl, in_pFormat);
#ifdef unix
	vswprintf(tmpBuffer, wcslen(tmpBuffer), in_pFormat, vl );
#else
	vswprintf_s(tmpBuffer, in_pFormat, vl );
#endif
	va_end( vl );
#ifndef unix
	OutputDebugStringW(tmpBuffer);
#endif
	app.LogMessage(tmpBuffer);
#endif // _DEBUG
}

static bool s_gbVerbose = true;
void setVerboseMode(bool in_bVerboseMode)
{
	s_gbVerbose = in_bVerboseMode;
}

void logmessage(wchar_t *in_pFormat, ...)
{
	if(s_gbVerbose)
	{
		Application app;

		wchar_t	tmpBuffer[4096];
		va_list vl;

		va_start( vl, in_pFormat);
		vswprintf(tmpBuffer, 
#ifdef unix
			sizeof(tmpBuffer),
#endif
			in_pFormat, vl );
		va_end( vl );
		app.LogMessage(tmpBuffer);
	}
}

void logerrormessage(wchar_t *in_pFormat, ...)
{
	Application app;

	wchar_t	tmpBuffer[4096];
	va_list vl;

	va_start( vl, in_pFormat);
	vswprintf(tmpBuffer, 
#ifdef unix
		sizeof(tmpBuffer),
#endif
		in_pFormat, vl );
	va_end( vl );
	app.LogMessage(tmpBuffer,siErrorMsg);
}

void	gWarningCallback( SI_Char* in_szMessage , SI_Int in_iLevel)
{
	Application app;
	XSI::CString strMessage;
	strMessage.PutAsciiString ( in_szMessage );
	app.LogMessage ( strMessage );

}
