#ifndef __ACCELPREDICTOR_H__
#define __ACCCELPREDICTOR_H__

#include "Predictor.h"

#pragma once

template<class T>
struct AccelPredictor : public IPredictor <T>
{
	AccelPredictor():m_values(0)
	{

	}

	virtual void Value(const T& x)
	{
		m_z = m_y;
		m_y = m_x;
		m_x = x;
		m_values++;
	}

	virtual bool Predict(T& y)
	{
		if(m_values<3)
			return false;
		SVec3 pred = m_x-m_y+m_x+(m_x-m_y)-(m_y-m_z);
		y = y - pred;
		return true;
	}

	T		m_x;
	T		m_y;
	T		m_z;
	size_t	m_values;
};

class CAccelPredictorCreator : public IPredictorCreator
{
public:
	IPredictor<SVec3>* Create()
	{
		return new AccelPredictor<SVec3>;
	}

private:
	CAccelPredictorCreator()
	{
		CPredictionHub::GetPredictorMap()["Accel"] = this;
	}

	static CAccelPredictorCreator s_singleton;
};

#endif /*__ACCELPREDICTOR_H__*/