#include "StdAfx.h"
#include "DataCollector.h"

CDataCollector::CDataCollector(uint32 session) : m_session(session)
{
	SYSTEMTIME time;
	GetSystemTime(&time);
	m_timestamp << time.wYear << "_" << time.wMonth << "_" << time.wDay << "_" << time.wHour << "-" << time.wMinute << "-" << time.wSecond;

	printf("new data collector [session=%u, timestamp=%s]\n", session, m_timestamp.str().c_str());
}

CDataCollector::~CDataCollector()
{
	for (std::map<uint32, std::ofstream*>::const_iterator itor = m_files.begin(); itor != m_files.end(); ++itor)
	{
		itor->second->close();
		delete itor->second;

		std::stringstream tmp;
		tmp << KeyToString(itor->first) << "_" << m_session << "_" << m_timestamp.str() << ".tmp";
		std::stringstream dat;
		dat << KeyToString(itor->first) << "_" << m_session << "_" << m_timestamp.str() << ".dat";

		rename( tmp.str().c_str(), dat.str().c_str() );
		//remove( tmp.str().c_str() );
	}
}

void CDataCollector::Collect(uint32 key, uint32 eid, const SVec3& v, const string& name)
{
	std::map<uint32, std::ofstream*>::const_iterator itor = m_files.find(key);
	if ( itor == m_files.end() )
	{
		std::stringstream filename;
		filename << KeyToString(key) << "_" << m_session << "_" << m_timestamp.str() << ".tmp";
		m_files[key] = new std::ofstream( filename.str().c_str(), std::ios::out|std::ios::binary );
		itor = m_files.find(key);
	}

	itor->second->write((const char*)&m_session,sizeof(m_session));
	itor->second->write((const char*)&eid,sizeof(eid));
	itor->second->write((const char*)&v,sizeof(v));

	size_t size = name.size();
	itor->second->write((const char*)&size,sizeof(size));
	itor->second->write((const char*)name.data(),name.size());
}

