#include "StdAfx.h"
#include "DataReader.h"


CDataReader::CDataReader(const std::string& name):m_file(name.c_str(),std::ios::in|std::ios::binary)
{
	if(!m_file.good())
		throw std::exception("File could not be read.");
}

CDataReader::~CDataReader()
{
	for(TChunkMap::iterator itr=m_currentChunks.begin();itr!=m_currentChunks.end();++itr)
	{
		delete itr->second.Data;
	}
}

void CDataReader::Reset()
{
	m_file.seekg(0,std::ios_base::beg);
	m_currentChunks.clear();
}

bool CDataReader::FlushChunk(IDataSink* sink,uint32 s_id,uint32 e_id,CDataReader::SData &data)
{
	bool stop=!sink->Data(s_id,e_id,&(*data.Data)[0],data.Data->size());
	data.Data->clear();
	return stop;
}

const size_t	BUFFER_SIZE = 1000000;

struct SBufferedReader
{
	SBufferedReader(std::ifstream& f):
	m_buf(new char[BUFFER_SIZE]),
	m_pos(0),
	m_size(0),
	m_file(f)
	{
	}

	bool good()const
	{
		return m_file.good();
	}

	bool eof()const
	{
		return m_pos == m_size && m_file.eof();
	}

	void ignore(size_t sz)
	{
		if(m_pos+sz>m_size)
			ReadNext(); 
		if(m_pos+sz<m_size)
			m_pos += sz;
		else
			m_pos = m_size;
	}

	void ReadNext()
	{
		std::copy(m_buf.get()+m_pos,m_buf.get()+m_size,m_buf.get());
		m_size -= m_pos;
		m_pos = 0;
		m_file.read(m_buf.get(),BUFFER_SIZE-m_size);
		m_size += m_file.gcount();
	}

	void read(char* buf, size_t sz)
	{
		if(m_pos+sz>m_size)
			ReadNext(); 
		if(m_pos+sz<m_size)
		{
			std::copy(m_buf.get(),m_buf.get()+sz,buf);
			m_pos += sz;
		}
		else
			m_pos = m_size;
	}

	std::auto_ptr<char>	m_buf;
	size_t		m_pos;
	size_t		m_size;
	std::ifstream	&m_file;
};

void CDataReader::Process(IDataSink* sink,int max_chunk_size)
{
	//SBufferedReader file(m_file);
	while(m_file.good() && !m_file.eof())
	{
		std::pair<uint32,uint32> ses_ent;
		m_file.read((char*)&ses_ent.first,sizeof(ses_ent.first));
		m_file.read((char*)&ses_ent.second,sizeof(ses_ent.second));

		SVec3 data;
		m_file.read((char*)&data,sizeof(data));

		uint32 sz;
		m_file.read((char*)&sz,sizeof(sz));
		m_file.ignore(sz);
		
		if(fabs(data.x)<MAX_VALUE && fabs(data.y)<MAX_VALUE && fabs(data.z)<MAX_VALUE)
			;
		else
			continue;

		TChunkMap::iterator itr=m_currentChunks.find(ses_ent);
		if(itr==m_currentChunks.end())
		{
			SData d;
			d.Data = new std::vector<SVec3>();
			itr=m_currentChunks.insert(TChunkMap::value_type(ses_ent,d)).first;
			if(max_chunk_size != -1)
				itr->second.Data->reserve(max_chunk_size);
		}

		itr->second.Data->push_back(data);

		if(itr->second.Data->size()&&itr->second.Data->size()==max_chunk_size)
		{
			if(FlushChunk(sink,ses_ent.first,ses_ent.second,itr->second))
			{
				return;
			}
		}
	}
	
	for(TChunkMap::iterator itr=m_currentChunks.begin();itr!=m_currentChunks.end();++itr)
	{
		if(itr->second.Data->empty())
			continue;
		if(FlushChunk(sink,itr->first.first,itr->first.second,itr->second))
		{
			return;
		}
	}
}



void CDataReader::Test(const std::string& name)
{
	CDataReader dr(name);

	struct CTestSink:public IDataSink
	{
		std::set<std::pair<uint32,uint32> > m_ents;
		size_t m_totalSize;

		CTestSink():m_totalSize(0)
		{
		}

		virtual bool Data(uint32 sess_id,uint32 ent_id,const SVec3 *data,size_t size)
		{
			m_ents.insert(std::make_pair(sess_id,ent_id));
			m_totalSize+=size;

			return true;
		}
	} testSink;

	dr.Process(&testSink,256);


	std::cout<<"CDataReader::Test()  File:"<<name<<" Entities:"<<testSink.m_ents.size()<<" Data Samples:"<<testSink.m_totalSize<<std::endl;
}