#ifndef __DATAREADER_H__
#define __DATAREADER_H__
#pragma once

#include "VectorMap.h"

class CDataReader
{
public:
	struct IDataSink
	{
		//return false to stop reading
		virtual bool Data(uint32 sess_id, uint32 ent_id, const SVec3* data, size_t size)=0;
		virtual ~IDataSink(){}
	};

	CDataReader(const std::string& name);
	~CDataReader();
	void	Reset();
	void	Process(IDataSink*,int max_chunk_size);

	static	void Test(const std::string& name);
private:
	struct SData
	{
		std::vector<SVec3>* Data;
	};

	typedef VectorMap<std::pair<uint32,uint32>,SData> TChunkMap;

	std::ifstream	m_file;
	TChunkMap		m_currentChunks;

	bool FlushChunk(IDataSink* sink,uint32 s_id,uint32 e_id,CDataReader::SData &data);
};



#endif /*__DATAREADER_H__*/
