#ifndef __STATS_COLLECTOR__
#define __STATS_COLLECTOR__
#pragma once

#include "thread.h"

class CStatsCollector
{
public:
	CStatsCollector(const uint32 toDump);
	void Data(const uint32 session_id,const char* name,const float bits);
	void EndPacket();

	void DumpPackets();

	static void Test();
private:
	typedef std::vector<std::pair<int,float> > TDataArray;
	typedef std::map<string,int> TNameToId;

	struct SPacket
	{
		 TDataArray Data;
	};

	typedef std::vector<SPacket> TPacketArray;

	struct SThreadInfo
	{
		TPacketArray	m_packets;
		TNameToId		m_nameToId;
	};


	uint32			m_toDump;
	CMutex			m_mtx;
	
	TPacketArray	m_packets;
	TNameToId		m_nameToId;

	

	static void DumpThread(void*);
	static CMutex	m_dumpMutex;
};

#endif //__STATS_COLLECTOR__