#ifndef __ZEROPREDICTOR_H__
#define __ZEROPREDICTOR_H__

#include "Predictor.h"

#pragma once

template<class T>
struct ZeroPredictor : public IPredictor <T>
{
	virtual void Value(const T& x)
	{
	}

	virtual bool Predict(T& y)
	{
		return true;
	}

};

class CZeroPredictorCreator : public IPredictorCreator
{
public:
	IPredictor<SVec3>* Create()
	{
		return new ZeroPredictor<SVec3>;
	}
private:
	CZeroPredictorCreator()
	{
		CPredictionHub::GetPredictorMap()["Zero"] = this;
	}

	static CZeroPredictorCreator s_singleton;
};

#endif /*__ZEROPREDICTOR_H__*/