#include "stdafx.h"
#include "httpd.h"
#include "data.h"
#include <iostream>

void CHTTPOutput::Write( const char * fmt, ... )
{
	char buf[8192];
	va_list args;
	va_start( args, fmt );
	vsprintf_s( buf, 8192, fmt, args );
	va_end( args );

	char * wbuf = buf;
	size_t len = strlen(buf);

	Put(wbuf, len);
}

void CHTTPOutput::Put( const char * wbuf, size_t len )
{
	while (len)
	{
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(m_sock, &fds);
		timeval timeout;
		timeout.tv_sec = 30;
		timeout.tv_usec = 0;
		// not portable to *nix
		int n = select(SOCKET(0), NULL, &fds, NULL, &timeout);
		switch (n)
		{
		case 0:
			throw std::runtime_error("Timeout on socket");
		case SOCKET_ERROR:
			throw std::runtime_error("Error waiting for write on socket");
		}
		int r = send( m_sock, wbuf, int(len), 0 );
		if (r == SOCKET_ERROR)
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
			{
				Sleep(1000);
				continue;
			}
			throw std::runtime_error("Error in send");
		}
		else if (r)
		{
			wbuf += r;
			len -= r;
		}
		else
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
			{
				Sleep(1000);
				continue;
			}
			throw std::runtime_error("No bytes received by recv");
		}
	}
}

void CHTTPOutput::WriteImage( CImage<iRGB>& img )
{
	Write("HTTP/1.0 200 Dandy\r\n");
	Write("content-type: image/png\r\n\r\n");

	png_structp png = png_create_write_struct( PNG_LIBPNG_VER_STRING, PngError, PngError, PngError );
	if (!png)
		return;
	png_infop info = png_create_info_struct( png );
	if (!info)
		return;
	if (setjmp(png_jmpbuf(png)))
	{
		png_destroy_write_struct(&png, &info);
		return;
	}
	png_set_write_fn(png, this, PngWrite, PngFlush);

	png_set_IHDR( png, info, img.GetWidth(), img.GetHeight(), 8, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE );
	png_write_info(png, info);

	std::vector<png_bytep> row_pointers;
	for (int i=0; i<img.GetHeight(); i++)
		row_pointers.push_back( (png_bytep)img.GetRow(i) );

	png_write_image(png, &row_pointers[0]);
	png_write_end(png, info);
	png_destroy_write_struct(&png, &info);
}

void CHTTPOutput::PngError( png_structp, const char * msg )
{
	SCOPED_GLOBAL_LOCK;
	std::cerr << "PNG Error: " << msg;
}

void CHTTPOutput::PngFlush( png_structp )
{
}

void CHTTPOutput::PngWrite( png_structp png, png_bytep data, png_size_t len )
{
	static_cast<CHTTPOutput*>(png_get_io_ptr(png))->Put((const char *)data, len);
}

void CHTTPD::Register( string dir, IServletPtr pServlet )
{
	m_servlets[dir] = pServlet;
}

void CHTTPD::Run( int port )
{
	CThread::SetName("httpd");

	bool errorFlag = true;

	SOCKET sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
	if (sock == INVALID_SOCKET)
		goto error_nothing;
	sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	if (0 != bind(sock, (sockaddr*)&addr, sizeof(addr)))
		goto error_withsock;
	if (SOCKET_ERROR == listen(sock, 1))
		goto error_withsock;
	while (true)
	{
		int n = sizeof(addr);
		SOCKET acc = accept(sock, (sockaddr*)&addr, &n);
		if (acc == SOCKET_ERROR)
			continue;
		if (n != sizeof(addr))
		{
			closesocket(acc);
			continue;
		}
		ProcessParams * pParams = new ProcessParams;
		pParams->addr = addr;
		pParams->sock = acc;
		pParams->pHTTPD = this;
		_beginthread( Process, 0, pParams );
	}

	errorFlag = false;

error_withsock:
	if (errorFlag)
	{
		fprintf(stderr, "error: %d\n", WSAGetLastError());
	}

	closesocket(sock);
error_nothing:
	return;
}

static void ParseUrl(const string& url,string& page, std::map<string,string>& p)
{
	string key, value;
	int state=0;
	
	for(string::const_iterator it=url.begin();;++it)
	{
		if(it==url.end())
		{
			if(!key.empty())
				p[key]=value;
			break;
		}
		switch(*it)
		{
		case '?':
			state = 1;
			break;
		case '&':
			if(!key.empty())
			{
				p[key]=value;
				key.clear();
				value.clear();
			}
			state = 1;
			break;
		case '=':
			state=2;
			break;
		default:
			switch(state)
			{
			case 0:page.push_back(*it);break;
			case 1:key.push_back(*it);break;
			case 2:value.push_back(*it);break;
			}
		}
	}
}

void CHTTPD::Process( void * p )
{
	static int num = 0;
	char buffer[256];
	sprintf_s(buffer, 256, "HTTPD connection %d", num++);
	CThread::SetName(buffer);

	ProcessParams * pParams = static_cast<ProcessParams*>(p);
	Socket sock(pParams->sock, 3);

	try
	{
		string uri;

		bool ok = false;
		if (sock.ReadByte() == 'G')
			if (sock.ReadByte() == 'E')
				if (sock.ReadByte() == 'T')
					ok = true;

		if (!ok)
			goto done;

		char c;
		while (' ' == (c = sock.ReadByte()))
			;
		uri += c;
		while (' ' != (c = sock.ReadByte()) && '\r' != c && '\n' != c)
			uri += c;

		string page;
		IServlet::ParamsMap params;
		
		ParseUrl(uri,page,params);

		fprintf(stderr, "get[%d] %s\n", num, uri.c_str());

		CHTTPOutput out(pParams->sock);
		std::map<string, IServletPtr>::iterator iter = pParams->pHTTPD->m_servlets.find(page);
		if (iter == pParams->pHTTPD->m_servlets.end())
		{
			out.Write("<html><body>");
			for (iter = pParams->pHTTPD->m_servlets.begin(); iter != pParams->pHTTPD->m_servlets.end(); ++iter)
			{
				out.Write("<a href=\"%s\">%s</a><br/>", iter->first.c_str(), iter->first.c_str());
			}
			out.Write("</html></body>");
		}
		else
		{
			iter->second->Get(&out, params);
		}
		out.Write("\r\n\r\n\r\n");
	}
	catch (std::exception& e)
	{
		fprintf(stderr, "error handling http request: %s\n", e.what());
	}

	shutdown(pParams->sock, SD_SEND);
	// probably there's a correct way of doing this; but this is a low-use tool, so it's probably also safe to do it this way!
	Sleep(1500);

done:
	delete pParams;
}
