#ifndef HTTPD_H
#define HTTPD_H

#include "smartptr.h"
#include "image.h"
#include <map>
#include "png.h"

class CHTTPOutput
{
public:
	CHTTPOutput( SOCKET sock ) : m_sock(sock) {}
	void Write( const char * fmt, ... );
	void WriteImage( CImage<iRGB>& img );

private:
	SOCKET m_sock;

	void Put( const char * data, size_t len );

	static void PngError( png_structp, const char * msg );
	static void PngWrite( png_structp, png_bytep, png_size_t );
	static void PngFlush( png_structp );
};

struct IServlet : public _reference_target_t
{
	typedef std::map<string,string>	ParamsMap;
	virtual void Get( CHTTPOutput * pOut, const ParamsMap& param ) = 0;
};
typedef _smart_ptr<IServlet> IServletPtr;

class CHTTPD
{
public:
	void Register( string dir, IServletPtr pServlet );
	void Run( int port );

private:
	std::map<string, IServletPtr> m_servlets;

	struct ProcessParams
	{
		sockaddr_in addr;
		SOCKET sock;
		CHTTPD * pHTTPD;
	};

	static void Process( void * p );
};

#endif
