#ifndef IMAGE_H
#define IMAGE_H

struct iRGB
{
	iRGB() : r(0), g(0), b(0) {}
	iRGB(uint8 rr, uint8 gg, uint8 bb) : r(rr), g(gg), b(bb) {}
	uint8 r, g, b;
	uint8& operator[](int i) { return ((uint8*)this)[i]; }
};

template <class T>
class CImage
{
public:
	CImage(int w, int h) : m_width(w), m_height(h), m_data(new T[m_width*m_height]) {}
	CImage(int w, int h, T def) : m_width(w), m_height(h), m_data(new T[m_width*m_height]) 
	{
		Clear(def);		
	}
	~CImage() { delete[] m_data; }

	void Clear(T def)
	{
		for (int i=0; i<m_width*m_height; i++)
			m_data[i] = def;
	}

	int GetWidth() const { return m_width; }
	int GetHeight() const { return m_height; }

	T * GetRow( int row )
	{
		return m_data + row * m_width;
	}

	T& operator()( int x, int y )
	{
		return m_data[y*m_width + x];
	}

private:
	CImage(const CImage&);
	CImage& operator=( const CImage& );

	int m_width;
	int m_height;
	T * m_data;
};



#endif
