#ifndef UTIL_H
#define UTIL_H

class Socket
{
public:
	Socket( SOCKET s, int pollTime = 30 );
	~Socket();
	uint8 ReadByte();

	bool operator ! () const { return m_socket == INVALID_SOCKET; }

private:
	static const size_t BUFFER_SIZE = 124;

	SOCKET m_socket;
	uint8 m_buffer[BUFFER_SIZE];
	size_t m_bufferSize;
	size_t m_bufferPos;
	int m_pollTime;
	uint32 m_cumRead;

	void Fetch();
};

sockaddr_in AddrFromString( std::string str );

template <class T>
static bool SetSockOpt( SOCKET s, int level, int optname, const T& value )
{
	return 0 == setsockopt( s, level, optname, (const char *)&value, sizeof(T) );
}

#endif
