/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 19:12:2005   12:10 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "IMaterialEffects.h"
#include "Beam.h"
#include "Weapon.h"
#include "Projectile.h"
#include "Actor.h"
#include "Game.h"
#include "GameRules.h"
#include <ISound.h>
#include <IEntitySystem.h>
#include "GameCVars.h"


//------------------------------------------------------------------------
CBeam::CBeam()
:	m_effectId(0),
	m_fireLoopId(INVALID_SOUNDID),
	m_hitSoundId(INVALID_SOUNDID),
	m_remote(false),
	m_viewFP(true),
	m_forcedDecals(0),
	m_lastMx(-1),
	m_bImpact(false)
{
	m_lastDecal[0]=m_lastDecal[1]=Vec3(ZERO);
	m_lastDecalSize[0]=m_lastDecalSize[1]=0;
}

//------------------------------------------------------------------------
CBeam::~CBeam()
{
}

//std::vector<Vec3> gpoints;

//------------------------------------------------------------------------
void CBeam::Update(float frameTime, uint frameId)
{

	//for (std::vector<Vec3>::iterator it=gpoints.begin(); gpoints.end()!=it;++it)
		//gEnv->pRenderer->GetIRenderAuxGeom()->DrawSphere(*it, 0.35f, ColorB(255, 128, 0, 255));

	bool keepUpdating=false;

	if(m_firing)
		m_fired = true;		//CSingle::Update overrides m_fired

	CSingle::Update(frameTime, frameId);

	if (m_firing)
	{
		keepUpdating=true;

		int slot = m_pWeapon->GetStats().fp ? CItem::eIGS_FirstPerson : CItem::eIGS_ThirdPerson;
		int id = m_pWeapon->GetStats().fp ? 0 : 1;

		if (m_spinUpTimer>0.0f)
		{
			m_spinUpTimer -= frameTime;

			if (m_spinUpTimer>0.0f)
			{
				m_pWeapon->RequireUpdate(eIUS_FireMode);
				return;
			}

			m_spinUpTimer = 0.0f;

			m_pWeapon->PlayAction(m_beamactions.blast.c_str());
			m_fireLoopId = m_pWeapon->PlayAction(m_actions.fire.c_str(), 0, true);

			ISound *pSound = m_pWeapon->GetSoundProxy()->GetSound(m_fireLoopId);
			if (pSound)
				pSound->SetLoopMode(true);

			SpinUpEffect(false);

			assert(m_effectId == 0);
			m_effectId = m_pWeapon->AttachEffect(slot, 0, true, m_effectparams.effect[id].c_str(), 
				m_effectparams.helper[id].c_str());

			//MuzzleFlashEffect(false);
			MuzzleFlashEffect(true);
		}

		IEntityClass* ammo = NULL;
		if(m_spinUpTimer==0.0f)
		{
			if (m_fireparams.ammo_type_class && m_fireparams.clip_size>=0)
			{
				if (m_ammoTimer>0.0f)
				{
					m_ammoTimer -= frameTime;
					if (m_ammoTimer <= 0.0f)
					{
						m_ammoTimer = m_beamparams.ammo_tick;

						//Decrease ammo count
						ammo = m_fireparams.ammo_type_class;
						int ammoCount = m_pWeapon->GetAmmoCount(ammo);

						if (m_fireparams.clip_size==0)
							ammoCount = m_pWeapon->GetInventoryAmmoCount(ammo);

						ammoCount=ammoCount-m_beamparams.ammo_drain;
						if(ammoCount>=0)
						{
							if (m_fireparams.clip_size != -1)
							{
								if (m_fireparams.clip_size!=0)
									m_pWeapon->SetAmmoCount(ammo, ammoCount);
								else
									m_pWeapon->SetInventoryAmmoCount(ammo, ammoCount);
							}
						}
						else
						{
							InternalStopFire(true);
						
							if (m_pWeapon->IsServer())
								m_pWeapon->GetGameObject()->InvokeRMI(CWeapon::ClStopFire(), CWeapon::EmptyParams(), eRMI_ToRemoteClients);

							if(m_pWeapon->GetInventoryAmmoCount(ammo)!=0)
							{
								Reload(m_pWeapon->IsZoomed()||m_pWeapon->IsZooming());
								if (m_pWeapon->IsServer())
									m_pWeapon->GetGameObject()->InvokeRMI(CWeapon::ClReload(), CWeapon::EmptyParams(), eRMI_ToRemoteClients);
							}
						}
					}
				}
			}
		}

		bool hitValid = false;
		ray_hit rayhit;

		Vec3 hit = GetProbableHit(m_beamparams.range, &hitValid, &rayhit);
		Vec3 pos = GetFiringPos(hit);
		Vec3 dir = GetFiringDir(hit, pos);

		m_pWeapon->OnShoot(m_pWeapon->GetOwnerId(), 0, ammo, pos, dir, Vec3(0,0,0));

		if (m_effectId)
		{
			int id = m_pWeapon->GetStats().fp?0:1;

			bool currentView = m_pWeapon->IsOwnerFP();
			//Check view changes and re-attach effect if needed (for vehicles)
			if(m_viewFP!=currentView)
			{
				m_viewFP = currentView;
				m_pWeapon->AttachEffect(m_viewFP?CItem::eIGS_ThirdPerson:CItem::eIGS_FirstPerson, m_effectId, false);
				m_effectId = m_pWeapon->AttachEffect(m_viewFP?CItem::eIGS_FirstPerson:CItem::eIGS_ThirdPerson,
					0, true, m_effectparams.effect[id].c_str(),	m_effectparams.helper[id].c_str());
				if(m_viewFP)
					m_pWeapon->PlayAction(g_pItemStrings->fire,0,false,CItem::eIPAF_Default|CItem::eIPAF_RepeatLastFrame);
			}

			Vec3 epos(m_pWeapon->GetEffectWorldTM(m_effectId).GetTranslation());
			
			if(m_effectparams.scale[id]<1.0f)
			{
				Quat rot;
				
				if (hitValid && m_beamparams.force_beam_correction)
					rot=Quat::CreateRotationVDir((rayhit.pt-pos).GetNormalizedSafe());
				else
					rot=Quat::CreateRotationVDir(dir);
				
				rot.Normalize();

				float scaleFX = 1.0f;	
				
				if (hitValid && m_beamparams.force_beam_correction)
					scaleFX = (((rayhit.pt-pos).len())*m_effectparams.scale[id]);
				else
					scaleFX = (((hit-pos).len())*m_effectparams.scale[id]);

				if(scaleFX>1.0f)
					scaleFX = 1.0f;

				Matrix34 etm;
				if (m_beamparams.force_beam_correction)
					etm.Set(Vec3(scaleFX,scaleFX,scaleFX),rot,pos);
				else
					etm.Set(Vec3(scaleFX,scaleFX,scaleFX),rot,epos);

				if(m_pWeapon->GetStats().fp)
					etm.OrthonormalizeFast();

				m_pWeapon->SetEffectWorldTM(m_effectId, etm);
			}
			else
			{
				Matrix34 etm(Matrix33::CreateRotationVDir(dir));
				etm.AddTranslation(epos);
				m_pWeapon->SetEffectWorldTM(m_effectId, etm);
			}

   
		}

    if (m_fireLoopId != INVALID_SOUNDID)
    {
      ISound *pSound = m_pWeapon->GetSoundProxy()->GetSound(m_fireLoopId);
      if (pSound)
        pSound->SetLineSpec(pos, hit);
    }    

		if (hitValid)
		{
			bool effect_changed=false;

			if (!m_beamparams.hit_type.empty())
			{
				IMaterialEffects* pMaterialEffects = gEnv->pGame->GetIGameFramework()->GetIMaterialEffects();
				TMFXEffectId mxId = pMaterialEffects->GetEffectId(m_beamparams.hit_type.c_str(), rayhit.surface_idx);

				if (mxId != m_lastMx)
				{
					m_lastMx =	mxId;
					effect_changed = true;
					SMFXResourceListPtr res=pMaterialEffects->GetResources(m_lastMx);

					if (res->m_soundList && res->m_soundList->m_soundParams.name)
						m_beamactions.hit=res->m_soundList->m_soundParams.name;
					else
						m_beamactions.hit="";

					if (res->m_particleList && res->m_particleList->m_particleParams.name)
						m_beamparams.hit_effect=res->m_particleList->m_particleParams.name;
					else
						m_beamparams.hit_effect="";

					if (res->m_decalList && res->m_decalList->m_decalParams.material)
					{
						m_beamparams.hit_decal=res->m_decalList->m_decalParams.material;

						if (!m_beamparams.hit_decal.empty())
							m_beamparams.hit_decal.append(".mtl");

						m_beamparams.hit_decal_size_min=res->m_decalList->m_decalParams.minscale;
						m_beamparams.hit_decal_size=res->m_decalList->m_decalParams.maxscale;
						m_beamparams.hit_decal_lifetime=res->m_decalList->m_decalParams.lifetime;

						if (res->m_decalList->pNext)
						{
							m_secondaryparams.hit_decal=res->m_decalList->pNext->m_decalParams.material;

							if (!m_secondaryparams.hit_decal.empty())
								m_secondaryparams.hit_decal.append(".mtl");

							m_secondaryparams.hit_decal_size_min=res->m_decalList->pNext->m_decalParams.minscale;
							m_secondaryparams.hit_decal_size=res->m_decalList->pNext->m_decalParams.maxscale;
							m_secondaryparams.hit_decal_lifetime=res->m_decalList->pNext->m_decalParams.lifetime;
						}
						else
						{
							m_secondaryparams.hit_decal="";
						}
					}
					else
					{
						m_beamparams.hit_decal="";
						m_secondaryparams.hit_decal="";
					}
				}
			}

			if (m_lastHitValid && effect_changed && m_hitSoundId != INVALID_SOUNDID)
			{
				m_pWeapon->StopSound(m_hitSoundId);
				m_hitSoundId = INVALID_SOUNDID;      
				// stop the effect here too
			}

			if (!m_lastHitValid || effect_changed)
			{
				m_hitSoundId = m_pWeapon->PlayAction(m_beamactions.hit.c_str(), 0, true, CItem::eIPAF_Default|CItem::eIPAF_ForceThirdPerson|CItem::eIPAF_SoundLooped|CItem::eIPAF_SoundStartPaused);
				ISound *pSound = m_pWeapon->GetISound(m_hitSoundId);
				if (pSound)
				{
					pSound->SetPosition(hit);
					pSound->SetPaused(false);
				}

				if (!m_hitbeameffectparams.effect[id].empty())
				{
					m_pWeapon->AttachEffect(0, m_effectId, false);
					m_effectId = m_pWeapon->AttachEffect(slot, 0, true, m_hitbeameffectparams.effect[id].c_str(), m_hitbeameffectparams.helper[id].c_str());
				}
			}

			// update sound pos/param
			if (m_hitSoundId != INVALID_SOUNDID)
			{
				ISound *pSound = m_pWeapon->GetISound(m_hitSoundId);
				if (pSound)
				{
          float angle = RAD2DEG(acos_tpl(rayhit.n.Dot(dir)));
					pSound->SetParam("angle", angle, false);				          
					pSound->SetPosition(hit);					

          //float color[] = {1,1,1,1};
          //gEnv->pRenderer->Draw2dLabel(200,300,1.5f,color,false,"angle: %.2f", angle);
				}
			}

			bool impact=false;
			if (!m_beamparams.hit_decal.empty())
			{
				//if (!m_lastHitValid)
				//if (!rayhit.pCollider || !gEnv->pEntitySystem->GetEntityFromPhysics(rayhit.pCollider))
				if (!m_lastHitValid || effect_changed)
				{
					m_lastDecal[0]=m_lastDecal[1]=Vec3(ZERO);
					m_lastDecalSize[0]=m_lastDecalSize[1]=0;
				}

				if (!m_beamparams.single_impact || !m_bImpact)
				{
					impact=true;

					Decal(m_beamparams, rayhit, dir, 0);

					if (!m_secondaryparams.hit_decal.empty())
						Decal(m_secondaryparams, rayhit, dir, 1);
				}

				//	if (m_beamparams.connect_hits && m_lastHitValid && !effect_changed)
				//		DecalLine(m_lastOrg, pos, m_lastHit, rayhit.pt, 0.5f);
				//else
				//{
					//Decal(rayhit, dir);
					//DecalLine(m_lastOrg, pos, m_lastHit, rayhit.pt, m_beamparams.hit_decal_size*0.1f);
				//}
			}
			else
			{
				m_lastDecal[0]=m_lastDecal[1]=Vec3(ZERO);
				m_lastDecalSize[0]=m_lastDecalSize[1]=0;
			}

			if (!m_beamparams.hit_effect.empty() && (!m_beamparams.single_impact || !m_bImpact))
			{
				impact=true;

				IParticleEffect *pParticleEffect = gEnv->p3DEngine->FindParticleEffect(m_beamparams.hit_effect.c_str());
				if (pParticleEffect)
				{
					Matrix34 loc=IParticleEffect::ParticleLoc(rayhit.pt, rayhit.n, m_beamparams.hit_effect_scale);
					if (rayhit.pCollider)
					{
						IEntity *pEntity = m_beamparams.linked_impacts ? gEnv->pEntitySystem->GetEntityFromPhysics(rayhit.pCollider) : NULL;

						if (pEntity)
						{
							int slot=pEntity->LoadParticleEmitter(-1, pParticleEffect);
							Matrix34 worldMatrix = pEntity->GetWorldTM();
							Matrix34 localMatrix = worldMatrix.GetInverted()*loc;
							pEntity->SetSlotLocalTM(slot, localMatrix);
						}
						else
						{
							pParticleEffect->Spawn(true, loc);
						}
					}
					else
					{
						pParticleEffect->Spawn(true, loc);
					}
				}
			}

			if (m_tickTimer>0.0f)
			{
				m_tickTimer -= frameTime;
				if (m_tickTimer <= 0.0f || (m_beamparams.single_impact && !m_bImpact))
				{
					Tick(rayhit, dir);

					m_tickTimer = m_beamparams.single_impact ? 0 : m_beamparams.tick;

					uint16 seq=m_pWeapon->GenerateShootSeqN();

					m_pWeapon->RequestShoot(0, ZERO, ZERO, ZERO, ZERO, 0, 0, seq, 0, false);

					if (m_beamparams.splash_radius > 0)
					{
						TickSplash(rayhit, dir);
					}
					else
					{
						TickDamage(rayhit, dir, seq);
					}
				}
			}

			if (impact)
				m_bImpact=true;

      Hit(rayhit, dir);

			m_lastOrg = pos;
			m_lastDir = dir;
			m_lastHit = rayhit.pt;
			m_lastHitValid = true;
		}
		else
		{
			if (!m_hitbeameffectparams.effect[id].empty() && m_lastHitValid)
			{
				m_pWeapon->AttachEffect(0, m_effectId, false);
				m_effectId = m_pWeapon->AttachEffect(slot, 0, true, m_effectparams.effect[id].c_str(), 
					m_effectparams.helper[id].c_str());
			}

			m_lastOrg = pos;
			m_lastDir = dir;
			m_lastHitValid = false;
		}
	}
	else
		m_lastHitValid = false;

	if (!m_lastHitValid)
	{
		if (m_hitSoundId != INVALID_SOUNDID)
		{
			m_pWeapon->StopSound(m_hitSoundId);
			m_hitSoundId = INVALID_SOUNDID;      
		}

		// stop the effect here too
	}

	if (keepUpdating)
		m_pWeapon->RequireUpdate(eIUS_FireMode);
}

//------------------------------------------------------------------------
void CBeam::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);

	const IItemParamsNode *beam = params?params->GetChild("beam"):0;
	const IItemParamsNode *effect = params?params->GetChild("effect"):0;
	const IItemParamsNode *hiteffect = params?params->GetChild("hiteffect"):0;
	const IItemParamsNode *actions = params?params->GetChild("actions"):0;

	m_beamparams.Reset(beam);
	m_secondaryparams.decal_density=m_beamparams.secondary_decal_density;
	m_effectparams.Reset(effect);
	m_hitbeameffectparams.Reset(hiteffect);
	m_beamactions.Reset(actions);
}

//------------------------------------------------------------------------
void CBeam::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);
	
	const IItemParamsNode *beam = patch?patch->GetChild("beam"):0;
	const IItemParamsNode *effect = patch?patch->GetChild("effect"):0;
	const IItemParamsNode *hiteffect = patch?patch->GetChild("hiteffect"):0;
	const IItemParamsNode *actions = patch?patch->GetChild("actions"):0;
	m_beamparams.Reset(beam, false);
	m_secondaryparams.decal_density=m_beamparams.secondary_decal_density;
	m_effectparams.Reset(effect, false);
	m_hitbeameffectparams.Reset(hiteffect, false);
	m_beamactions.Reset(actions, false);
}

//------------------------------------------------------------------------
void CBeam::Activate(bool activate)
{
	//gpoints.resize(0);
	CSingle::Activate(activate);

	m_firing = false;
	m_remote = false;

	if (m_fireLoopId != INVALID_SOUNDID)
	{
		m_pWeapon->StopSound(m_fireLoopId);
		m_fireLoopId = INVALID_SOUNDID;
	}

	if (m_hitSoundId != INVALID_SOUNDID)
	{
		m_pWeapon->StopSound(m_hitSoundId);
		m_hitSoundId = INVALID_SOUNDID;
	}

	SpinUpEffect(false);

	if (m_effectId)
	{
		m_pWeapon->AttachEffect(0, m_effectId, false);
		m_effectId=0;
	}

	int slot = m_pWeapon->GetStats().fp ? CItem::eIGS_FirstPerson : CItem::eIGS_ThirdPerson;
	int id = m_pWeapon->GetStats().fp ? 0 : 1;
	m_pWeapon->ResetEffectsAtHelper(slot, m_effectparams.helper[id].c_str());


	m_lastHitValid=false;
	m_tickTimer = m_beamparams.tick;
	m_ammoTimer = m_beamparams.ammo_tick;

	m_bImpact=false;

	if (m_beamparams.reload_feedback && OutOfAmmo())
	{
		m_next_shot = m_next_shot_dt;
	}
}

//------------------------------------------------------------------------
//bool CBeam::OutOfAmmo() const
//{
	//return false;
//}

//------------------------------------------------------------------------
//bool CBeam::CanReload() const
//{
	//return false;
//}

//------------------------------------------------------------------------
bool CBeam::CanFire(bool considerAmmo) const
{
	return !m_reloading && !m_firing && (m_next_shot<=0.0f) && (m_spinUpTime<=0.0f) && (m_overheat<=0.0f) &&
		!m_pWeapon->IsBusy() && (!considerAmmo || !OutOfAmmo() || !m_fireparams.ammo_type_class || m_fireparams.clip_size == -1);
}

//------------------------------------------------------------------------
void CBeam::StartFire()
{
	IEntityClass* ammo = m_fireparams.ammo_type_class;
	int ammoCount = ammo ? m_pWeapon->GetAmmoCount(ammo) : 1;

	if (!CanFire(true))
	{
		if ((ammoCount <= 0) && !m_reloading && !m_reloadPending)
		{
			m_pWeapon->Reload();
		}
		return;
	}
	else if(m_pWeapon->IsWeaponLowered())
	{
		m_pWeapon->PlayAction(m_actions.null_fire);
		return;
	}

	m_lastHitValid = false;
	m_firing = true;
	m_spinUpTimer = m_fireparams.spin_up_time;
	m_tickTimer = m_beamparams.tick;
	m_ammoTimer = m_beamparams.ammo_tick;
	m_lastDecal[0]=m_lastDecal[1] = Vec3(ZERO);
	m_lastDecalSize[0]=m_lastDecalSize[1]=0;
	m_lastMx=-1;

	m_bImpact=false;

	m_fired = true;			//For recoil

	SpinUpEffect(true);
	m_pWeapon->PlayAction(m_actions.spin_up.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);
	m_pWeapon->RequireUpdate(eIUS_FireMode);

	m_pWeapon->RequestStartFire();

	m_viewFP = m_pWeapon->IsOwnerFP();

	if (m_beamparams.reload_feedback)
	{
		m_next_shot = m_next_shot_dt;
	}
}

//------------------------------------------------------------------------
void CBeam::StopFire()
{
	//Prevent being stopped if it is not firing
	if(!m_firing)
		return;

	InternalStopFire(false);
}

//------------------------------------------------------------------------
void CBeam::StartReload(int zoomed)
{
	CSingle::StartReload(zoomed);

	if (m_beamparams.reload_feedback)
	{
		m_next_shot = m_next_shot_dt;
		m_pWeapon->RequireUpdate(eIUS_FireMode);
	}
}

//------------------------------------------------------------------------
void CBeam::NetStartFire()
{
	m_lastHitValid = false;
	m_firing = true;
	m_spinUpTimer = m_fireparams.spin_up_time;
	m_tickTimer = m_beamparams.tick;
	m_ammoTimer = m_beamparams.ammo_tick;
	m_lastDecal[0]=m_lastDecal[1]=Vec3(ZERO);
	m_lastDecalSize[0]=m_lastDecalSize[1]=0;
	m_lastMx=-1;

	m_bImpact=false;

	m_remote = true;

	m_fired = true;

	SpinUpEffect(true);
	m_pWeapon->PlayAction(m_actions.spin_up.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);
	m_pWeapon->RequireUpdate(eIUS_FireMode);
}

//------------------------------------------------------------------------
void CBeam::NetStopFire()
{
	//Prevent being stopped if it is not firing
	if(!m_firing)
		return;

	m_firing = false;
	m_fired  = false;
	m_remote = false;

	SpinUpEffect(false);

	if (m_effectId)
	{
		m_pWeapon->AttachEffect(CItem::eIGS_FirstPerson, m_effectId, false);
		m_effectId=0;
	}

	if (m_fireLoopId != INVALID_SOUNDID)
	{
		m_pWeapon->StopSound(m_fireLoopId);
		m_fireLoopId = INVALID_SOUNDID;
	}

	m_pWeapon->PlayAction(m_actions.spin_down.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);
	m_pWeapon->EnableUpdate(false, eIUS_FireMode);
}
//------------------------------------------------------------------------

//------------------------------------------------------------------------
void CBeam::Decal(const SBeamParams & params, const ray_hit &rayhit, const Vec3 &dir, unsigned int group, float scale/*=1.0f*/)
{
	CryEngineDecalInfo decal;

	//	gpoints.push_back(rayhit.pt);
	decal.vPos = rayhit.pt;
	decal.vNormal = rayhit.n;
	decal.fSize = params.hit_decal_size;
  if (params.hit_decal_size_min != 0.f)
    decal.fSize -= Random()*max(0.f, params.hit_decal_size-params.hit_decal_size_min);
	decal.fSize*=scale;
	decal.fLifeTime = params.hit_decal_lifetime;
	decal.bAdjustPos = true;
	decal.nGroupId=group;
	if (group == 0)
		decal.sortPrio=254;

	strcpy(decal.szMaterialName, params.hit_decal.c_str());

	decal.fAngle = m_beamparams.decals_random_rotation ? Random(0.0f, 359.9f) : RAD2DEG(acos_tpl(rayhit.n.Dot(dir)));
	decal.vHitDirection = m_beamparams.decal_density > 0 ? -rayhit.n : dir;
	
	// Make a dense decal line
	if (params.decal_density > 0)
	{
		if (m_lastDecalSize > 0)
		{
			// HACK: Decal manager refuses to create decals from dist < 1.5xlast+2xcurrent
			float cdist=sqr(1.5f*m_lastDecalSize[group]+2.0f*decal.fSize);
			float dist=(decal.vPos-m_lastDecal[group]).GetLengthSquared();

			// This decal is far away enough from the precious one, it should be spawned regardless of the decal manager's decision
			if (dist > cdist*m_beamparams.decal_density)
			{
				// Save last surely visible decal
				m_lastDecal[group]=decal.vPos;
				m_lastDecalSize[group]=decal.fSize;

				// Decal manager would decide on not showing: force!
				if (dist < cdist)
				{
					decal.bSkipOverlappingTest=true;
					//m_forcedDecals++;
					//gEnv->pLog->Log(">>> Decal forced %d!", m_forcedDecals);
				}
			}
		}
		else
		{
			m_lastDecal[group]=decal.vPos;
			m_lastDecalSize[group]=decal.fSize;
		}
	}
	else if (params.decal_density < 0)
	{
		decal.bSkipOverlappingTest=true;
	}

	if (rayhit.pCollider)
	{
		if (IRenderNode* pRenderNode = (IRenderNode*)rayhit.pCollider->GetForeignData(PHYS_FOREIGN_ID_STATIC))
			decal.ownerInfo.pRenderNode = pRenderNode;
		else if (IEntity *pEntity = gEnv->pEntitySystem->GetEntityFromPhysics(rayhit.pCollider))
		{
			IEntityRenderProxy *pRenderProxy = (IEntityRenderProxy*)pEntity->GetProxy(ENTITY_PROXY_RENDER);;
			if (pRenderProxy)
				decal.ownerInfo.pRenderNode = pRenderProxy->GetRenderNode();
		}
	}

	gEnv->p3DEngine->CreateDecal(decal);
}

//------------------------------------------------------------------------
void CBeam::Hit(ray_hit &hit, const Vec3 &dir)
{
}

//------------------------------------------------------------------------
void CBeam::Tick(ray_hit &hit, const Vec3 &dir)
{
}

//------------------------------------------------------------------------
void CBeam::TickDamage(ray_hit &hit, const Vec3 &dir, uint16 seq)
{	
	if (m_fireparams.damage==0)
		return;

	IEntity *pEntity = gEnv->pEntitySystem->GetEntityFromPhysics(hit.pCollider);

	if (pEntity)
	{
		CGameRules *pGameRules = g_pGame->GetGameRules();

		HitInfo info(m_pWeapon->GetOwnerId(), pEntity->GetId(), m_pWeapon->GetEntityId(), 
			m_pWeapon->GetFireModeIdx(GetName()), 0.25f, pGameRules->GetHitMaterialIdFromSurfaceId(hit.surface_idx), hit.partid, 
			pGameRules->GetHitTypeId(m_fireparams.hit_type.c_str()), hit.pt, dir, hit.n);

		if (m_pWeapon->GetForcedHitMaterial() != -1)
			info.material=pGameRules->GetHitMaterialIdFromSurfaceId(m_pWeapon->GetForcedHitMaterial());

		info.remote = m_remote;
		if (!m_remote)
			info.seq=seq;
		info.damage = m_fireparams.damage;

		pGameRules->ClientHit(info);
	}
}
//------------------------------------------------------------------------
void CBeam::TickSplash(ray_hit &hit, const Vec3 &dir)
{
	if (m_fireparams.damage==0)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();

	ExplosionInfo explosion(m_pWeapon->GetOwnerId(), m_pWeapon->GetEntityId(), m_fireparams.damage, hit.pt, dir, m_beamparams.splash_min_radius, 
		m_beamparams.splash_radius, m_beamparams.splash_phys_min_radius, m_beamparams.splash_phys_radius, 0, m_beamparams.splash_phys_push, 0, 
		pGameRules->GetHitTypeId(m_fireparams.hit_type.c_str()), 0);

	IEntity *pEntity = gEnv->pEntitySystem->GetEntityFromPhysics(hit.pCollider);
	if (pEntity)
	{
		explosion.impact=true;
		//explosion.impact_targetId=pEntity->GetId();
		explosion.SetImpact(hit.n, dir*m_beamparams.splash_phys_push, pEntity->GetId());

		// Add impulse to impact target
		IPhysicalEntity *pPhys=m_beamparams.splash_phys_radius > 0 ? pEntity->GetPhysics() : 0;
		if (pPhys)
		{
			pe_action_impulse imp;
			imp.impulse=dir*m_beamparams.splash_phys_push*10;
			imp.point=hit.pt;
			pPhys->Action(&imp);
		}
	}

	if (gEnv->bServer)
		pGameRules->ServerExplosion(explosion);

	//gEnv->pLog->Log(">>>>>>>>>> Splashing in BEAM");
}
//------------------------------------------------------------------------
void CBeam::InternalStopFire(bool force)
{
	if(!force && m_beamparams.auto_charge)
		return;

	if(m_firing)
	{
		SmokeEffect();

		if (!m_bImpact)
		{
			SplitEffect();
		}
	}

	m_firing = false;
	m_fired  = false;

	SpinUpEffect(false);

	if (m_effectId)
	{
		m_pWeapon->AttachEffect(0, m_effectId, false);
		m_effectId=0;
	}

	if (m_fireLoopId != INVALID_SOUNDID)
	{
		m_pWeapon->StopSound(m_fireLoopId);
		m_fireLoopId = INVALID_SOUNDID;
	}

	m_pWeapon->PlayAction(m_actions.spin_down.c_str(), 0, false, CItem::eIPAF_Default|CItem::eIPAF_CleanBlending);
	m_pWeapon->EnableUpdate(false, eIUS_FireMode);

	m_pWeapon->RequestStopFire();
}
//------------------------------------------------------------------------
void CBeam::SplitEffect()
{
	if (m_beamparams.split && m_fireparams.ammo_type_class)
	{
		CProjectile *pAmmo = m_pWeapon->SpawnAmmo(m_fireparams.ammo_type_class, false);
		if (pAmmo)
		{
			if (m_fireparams.track_projectiles && (gEnv->bServer || pAmmo->IsPredicted()))
				pAmmo->SetTracked(true);

			CGameRules* pGameRules = g_pGame->GetGameRules();

			float damage = m_fireparams.damage;

			pAmmo->SetParams(m_pWeapon->GetOwnerId(), m_pWeapon->GetHostId(), m_pWeapon->GetEntityId(), m_pWeapon->GetFireModeIdx(GetName()),
				(int)damage, pGameRules->GetHitTypeId(m_fireparams.hit_type.c_str()));
			pAmmo->InitWithAI();
			pAmmo->SetDestination(m_pWeapon->GetDestination());
			pAmmo->Launch(m_lastOrg+m_lastDir*m_beamparams.range, m_lastDir, Vec3(ZERO), m_speed_scale);
			pAmmo->Timeout(m_lastDir);
		}
	}
}
//------------------------------------------------------------------------
void CBeam::GetMemoryStatistics(ICrySizer * s)
{
	s->Add(*this);
	CSingle::GetMemoryStatistics(s);
	m_beamparams.GetMemoryStatistics(s);
	m_beamactions.GetMemoryStatistics(s);
	m_effectparams.GetMemoryStatistics(s);
}
