/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Special helper firemode for smartbomb launchers

-------------------------------------------------------------------------
History:
- 16:08:2007   : Created by Denisz Polgar

*************************************************************************/
#ifndef __BOMB_LAUNCH_H__
#define __BOMB_LAUNCH_H__

#if _MSC_VER > 1000
# pragma once
#endif


class CBombLaunch :
	public CShotgun
{
class ReloadOneShellAction;

public:

protected:
	typedef struct SBombLaunchParams
	{
		SBombLaunchParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);

			float input;
			ResetValueEx("effective_range", input, 50);

			effective_range_sqr=input*input;
		}

		float effective_range_sqr;
	} SBombLaunchParams;

public:
	CBombLaunch();
	virtual ~CBombLaunch();

	virtual void Init(IWeapon *pWeapon, const IItemParamsNode *params);

	virtual bool Shoot(bool resetAnimation, bool autoreload = true , bool noSound = false );

	virtual void StartReload(int zoomed);
	virtual void ReloadShell(int zoomed);
	virtual void EndReload(int zoomed);

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual void Update(float frameTime, uint frameId);

	void ReleaseProjectiles();

	void ResetBombs();
	void ResetInstaLoad();
	
	virtual const char* GetType() const;

	virtual void Serialize(TSerialize ser);
	virtual void PostSerialize();
protected:

	void LaunchBomb(float speedScale);
	void InstaLoad();

	SBombLaunchParams m_bombLaunchParams;

	typedef std::vector <EntityId> TLoadedBombs;
	TLoadedBombs m_loadedBombs;

	bool m_loadingBombs;
	bool m_instaLoaded;

	int m_instaLoadCount;
private:
};


#endif //__BOMB_LAUNCH_H__
