/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id:$
$DateTime$
Description:  
-------------------------------------------------------------------------
History:
- 16:08:2007   : Created by Denisz Polgar

*************************************************************************/
#include "StdAfx.h"
#include "Projectile.h"
#include "GravityBomb.h"
#include "Actor.h"
#include "GameRules.h"

CGravityBomb::CGravityBomb()
:CProjectile(),
m_lastDetectionTime(0),
m_detectionInterval(0),
m_attractionRange(0),
m_attractionForce(0),
m_minDistanceDivider(1),
m_playerScale(1),
m_impactTime(0),
m_armedEffect(0),
m_armedEffectId(-1),
m_bArmed(false)
{
}

//-------------------------------------------
CGravityBomb::~CGravityBomb()
{
}

//-------------------------------------------
bool CGravityBomb::Init(IGameObject *pGameObject)
{
	bool res=CProjectile::Init(pGameObject);

	m_detectionInterval=GetParam("detectionterval", m_detectionInterval);
	m_attractionRange=GetParam("attractionrange", m_attractionRange);
	m_attractionForce=GetParam("attractionforce", m_attractionForce);
	m_minDistanceDivider=GetParam("mindistancedivider", m_minDistanceDivider);
	m_playerScale=GetParam("playerscale", m_playerScale);
	m_armedEffect=GetParam("armedeffect", m_armedEffect);

	return res;
}

//------------------------------------------
void CGravityBomb::HandleEvent(const SGameObjectEvent &event)
{
	if (m_destroying)
		return;

	CProjectile::HandleEvent(event);

	if (event.event == eGFE_OnCollision)
	{
		if (m_totalLifetime > 1.0f)
		{
			if (m_bArmed && m_totalLifetime-m_impactTime > 3.0f)
			{
				Explode(true);
			}
			else if (m_impactTime == 0)
			{
				m_impactTime=m_totalLifetime;
			}
		}
	}
}

void CGravityBomb::Update( SEntityUpdateContext &ctx, int updateSlot)
{
	CProjectile::Update(ctx, updateSlot);

	if (m_destroying)
		return;

	if (!m_bArmed && m_impactTime > 0 && m_totalLifetime-m_impactTime > 3.0f)
	{
		m_impactTime=m_totalLifetime;
		m_bArmed=true;

		if (m_armedEffectId < 0)
			m_armedEffectId=AttachEffect(true, 0, m_armedEffect);
	}

	if (m_bArmed)
	{
		Vec3 centre=GetEntity()->GetWorldPos();

		if (ctx.fCurrTime-m_lastDetectionTime > m_detectionInterval)
		{
			m_lastDetectionTime=ctx.fCurrTime;
			
			IEntity *pOwnerEntity = gEnv->pEntitySystem->GetEntity(m_ownerId);
			SEntityProximityQuery query;
			//query.nEntityFlags=ENTITY_FLAG_CALC_PHYSICS;
			query.box = AABB(centre-Vec3(m_attractionRange, m_attractionRange, m_attractionRange), centre+Vec3(m_attractionRange, m_attractionRange, m_attractionRange));
						
			int count = gEnv->pEntitySystem->QueryProximity(query);
			for(int i=0; i<query.nCount; ++i)
			{
				IEntity* pEntity = query.pEntities[i];

				if (pOwnerEntity && pEntity->GetId() == pOwnerEntity->GetId())
					continue;

				if (pEntity && pEntity->GetPhysics() && pEntity->GetId() != GetEntity()->GetId())
				{
					TAttractedVictims::iterator it=m_attractedVictims.find(pEntity->GetId());
					if (it == m_attractedVictims.end())
					{
						m_attractedVictims.insert(TAttractedVictims::value_type(pEntity->GetId(), 1));
					}
					else
					{
						it->second=1;
					}
				}
			}
		}

		for (TAttractedVictims::iterator it=m_attractedVictims.begin(); it!=m_attractedVictims.end(); ++it)
		{
			IEntity *pEntity=gEnv->pEntitySystem->GetEntity(it->first);

			if (pEntity)
			{
				Vec3 pulldir;
				float dst=0;

				if (it->second)
				{
					pulldir=centre-pEntity->GetWorldPos();

					// For gravity like behavior you'd need squared, but it ruins gameplay
					//dst=pulldir.GetLengthSquared();
					dst=pulldir.GetLength();
					
					if (dst > m_attractionRange)
					{
						it->second=0;
					}
				}

				if (!it->second)
					continue;

				IPhysicalEntity *pPhys=pEntity->GetPhysics();

				if (pPhys)
				{
					float typeScale=1.0f;
					IAIObject *pAI=pEntity->GetAI();

					if (pAI && pAI->GetAIType()==AIOBJECT_PLAYER)
						typeScale=m_playerScale;

					pe_status_dynamics dyn;
					pPhys->GetStatus(&dyn);

					pulldir.Normalize();
					// For gravity like behavior you'd need squared, but it ruins gameplay
					dst=sqrt(dst);

					// To avoid very large forces arising at short distances
					if (dst < m_minDistanceDivider)
						dst=m_minDistanceDivider;

					float force=(m_attractionForce*dyn.mass*typeScale*ctx.fFrameTime)/sqrt(dst);

					pe_action_impulse impulse;
					impulse.impulse=pulldir*force;

					pPhys->Action(&impulse);
				}
			}
		}
	}
}

void CGravityBomb::ProcessEvent(SEntityEvent &event)
{
	if (event.event == ENTITY_EVENT_TIMER && event.nParam[0])
	{
		Explode(true);
	}
}

void CGravityBomb::Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity, float speedScale)
{
	Vec3 corrpos=pos;
	corrpos+=dir*10;
	CProjectile::Launch(corrpos, dir, velocity, speedScale);

	/*IPhysicalEntity *pPhys=GetEntity()->GetPhysics();

	if (pPhys)
	{
		Vec3 pos=GetEntity()->GetPos();

		pos+=m_initial_dir*10;

		pe_params_pos ppos;
		ppos.pos=pos;
		pPhys->SetParams(&ppos);
		GetEntity()->SetPos(pos);
	}*/
}

void CGravityBomb::FullSerialize(TSerialize ser )
{
	CProjectile::FullSerialize(ser);

	ser.BeginGroup("gravity_projectile");
	ser.Value("impact_time", m_impactTime);
	ser.Value("armed", m_bArmed);
	ser.Value("victims", m_attractedVictims);
	ser.EndGroup();
}

void CGravityBomb::PostSerialize()
{
	CProjectile::PostSerialize();

	// Reset trail sound id so first update creates a new sound for it
	TrailSound(false);
	m_armedEffectId=-1;
	TrailEffect(true);
}