/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id:$
$DateTime$
Description:  Gravity Bomb implementation
-------------------------------------------------------------------------
History:
- 17:08:2007   : Created by Denisz Polgar

*************************************************************************/

#ifndef __GRAVITYBOMB_H__
#define __GRAVITYBOMB_H__

#if _MSC_VER > 1000
# pragma once
#endif


class CGravityBomb : public CProjectile
{
public:
	CGravityBomb();
	virtual ~CGravityBomb();

	virtual bool Init(IGameObject *pGameObject);
	virtual void HandleEvent(const SGameObjectEvent &evnt);

	virtual void Update( SEntityUpdateContext &ctx, int updateSlot);
	virtual void ProcessEvent(SEntityEvent &event);

	virtual void Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity, float speedScale=1.0f);

	virtual void FullSerialize( TSerialize ser );
	virtual void PostSerialize();

private:
	float m_lastDetectionTime;
	float m_detectionInterval;
	float m_attractionRange;
	float m_attractionForce;
	float m_minDistanceDivider;
	float m_playerScale;

	float m_impactTime;

	bool m_bArmed;
	const char* m_armedEffect;
	int m_armedEffectId;

	typedef std::map <EntityId, int> TAttractedVictims;
	TAttractedVictims	m_attractedVictims;
};

#endif