/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id:$
$DateTime$
Description:  Scout Smart Bomb implementation
-------------------------------------------------------------------------
History:
- 16:08:2007   : Created by Denisz Polgar

*************************************************************************/

#ifndef __SMARTBOMB_H__
#define __SMARTBOMB_H__

#if _MSC_VER > 1000
# pragma once
#endif

#define SMARTBOMB_SMART		1979
#define SMARTBOMB_DUMB		-29

class CSmartBomb : public CProjectile
{
public:
	CSmartBomb();
	virtual ~CSmartBomb();

	virtual bool Init(IGameObject *pGameObject);
	virtual void HandleEvent(const SGameObjectEvent &evnt);

	virtual void Update( SEntityUpdateContext &ctx, int updateSlot);
	virtual void ProcessEvent(SEntityEvent &event);

	virtual void Launch(const Vec3 &pos, const Vec3 &dir, const Vec3 &velocity, float speedScale=1.0f);
	virtual void Explode(bool destroy, bool impact=false, const Vec3 &pos=ZERO, const Vec3 &normal=FORWARD_DIRECTION, const Vec3 &vel=ZERO, EntityId targetId=0 );

	virtual void FullSerialize( TSerialize ser );
	virtual void PostSerialize();

// SECURITY: Nanosuit
static int m_sSmart;
static int m_sDumb;

private:
	/*
	float m_playerScale;

	float m_impactTime;
	*/
	void ArmedEffect(bool enable);
	void ArmedSound(bool enable);

	bool m_bArmed;
	EntityId m_targetId;

	float m_launchedLifetime;
	float m_launchedMass;

	float m_attractionRange;
	float m_lastDetectionTime;
	float m_detectionInterval;

	float m_attractionForce;
	float m_minDistance;
	float m_maxDistance;
	float m_explosionProximity;
	float m_safetyTimeout;
	float m_searchTimeout;
	float m_jump;

	const char* m_armedEffect;
	const char* m_armedSound;
	int m_armedEffectId;
	int m_armedSoundId;

	bool m_bAutoArm;
	bool m_bLateReactor;
	bool m_bImpactExplode;
	float m_fScatter;

	float m_maxSpeed;

	bool m_bReadyToLaunch;
	bool m_bLaunched;
	bool m_bPhysSetUp;

	float m_armTime;

	float m_playerAggression;
	float m_dynamicLifetimeScale;

	float m_trackInaccuracy;
	float m_trackInaccuracyTimeout;

	Vec3 m_lastTrackDivergence;
	float m_nextTrackRecalculate;
};

#endif