/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 16:08:2007   : Created by Denisz Polgar

*************************************************************************/
#include "StdAfx.h"
#include "Single.h"
#include "Shotgun.h"
#include "SuitPowered.h"
#include "Item.h"
#include "Weapon.h"
#include "Projectile.h"
#include "Actor.h"
#include "Player.h"
#include "Game.h"
#include "GameCVars.h"
#include "HUD/HUD.h"
#include "HUD/HUDRadar.h"
#include "WeaponSystem.h"
#include <IEntitySystem.h>
#include "ISound.h"
#include <IVehicleSystem.h>
#include <IMaterialEffects.h>
#include "GameRules.h"
#include <Cry_GeoDistance.h>

#include "IronSight.h"

#include "IRenderer.h"
#include "IRenderAuxGeom.h"

uint8 CSuitPowered::m_sTacticsOn = 127;

CSuitPowered::CSuitPowered()
{

}

CSuitPowered::~CSuitPowered()
{

}

void CSuitPowered::Init(IWeapon *pWeapon, const IItemParamsNode *params)
{
	CSingle::Init(pWeapon, params);
}

//------------------------------------------------------------------------
bool CSuitPowered::CanFire(bool considerAmmo) const
{
	bool res=true;

	CActor *pActor=m_pWeapon->GetOwnerActor();
	if (pActor)
	{
		CPlayer* pPlayer = static_cast<CPlayer*>(pActor);

		if (pPlayer)
		{
			if (CNanoSuit* pSuit = pPlayer->GetNanoSuit())
			{
				res=pSuit->GetSuitEnergy()-m_suitParams.min_power > 0;
			}
		}
	}

	return CSingle::CanFire(considerAmmo) && res;
}

//------------------------------------------------------------------------
bool CSuitPowered::Shoot(bool resetAnimation, bool autoreload/* =true */, bool noSound /* =false */)
{
	if (!CanFire(true))
		return false;
	
	bool res=CSingle::Shoot(resetAnimation, autoreload, noSound);

	if (res)
	{
		CActor *pActor=m_pWeapon->GetOwnerActor();
		if (pActor)
		{
			CPlayer* pPlayer = static_cast<CPlayer*>(pActor);

			if (pPlayer)
			{
				if (CNanoSuit* pSuit = pPlayer->GetNanoSuit())
				{
					if (m_suitParams.power_drain > 0)
					{
						pSuit->SetSuitEnergy(pSuit->GetSuitEnergy()-m_suitParams.power_drain);
					}
					else if (m_suitParams.power_drain < 0)
					{
						pSuit->Activate(false);
						pSuit->SetSuitEnergy(0.0f);
						pSuit->Activate(true, -1*m_suitParams.power_drain);

						pPlayer->GetGameObject()->InvokeRMI(CPlayer::ClEMP(), CPlayer::EMPParams(-1*m_suitParams.power_drain), eRMI_ToClientChannel, pPlayer->GetChannelId());
					}
				}
			}
		}
	}

	return true;
}
//------------------------------------------------------------------------
void CSuitPowered::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);

	const IItemParamsNode *suit = params?params->GetChild("suit_powered"):0;
	m_suitParams.Reset(suit);
}

//------------------------------------------------------------------------
void CSuitPowered::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);

	const IItemParamsNode *suit = patch->GetChild("suit_powered");
	m_suitParams.Reset(suit, false);
}

//------------------------------------------------------------------------
const char *CSuitPowered::GetType() const
{
	return "SuitPowered";
}
