/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Special helper firemode for smartbomb launchers

-------------------------------------------------------------------------
History:
- 16:08:2007   : Created by Denisz Polgar

*************************************************************************/
#ifndef __SUIT_POWERED_H__
#define __SUIT_POWERED_H__

#if _MSC_VER > 1000
# pragma once
#endif


class CSuitPowered :
	public CSingle
{
public:

protected:
	typedef struct SSuitPoweredParams
	{
		SSuitPoweredParams() { Reset(); };
		void Reset(const IItemParamsNode *params=0, bool defaultInit=true)
		{
			CItemParamReader reader(params);

			ResetValueEx("power_drain", power_drain, 50);
			ResetValueEx("min_power", min_power, 50);
		}

		float power_drain;
		float min_power;
	} SSuitPoweredParams;

public:
	CSuitPowered();
	virtual ~CSuitPowered();

	virtual void Init(IWeapon *pWeapon, const IItemParamsNode *params);
	virtual bool CanFire(bool considerAmmo = true) const;
	virtual bool Shoot(bool resetAnimation, bool autoreload = true , bool noSound = false );

	virtual void ResetParams(const struct IItemParamsNode *params);
	virtual void PatchParams(const struct IItemParamsNode *patch);

	virtual const char* GetType() const;

	// SECURITY: Bullet spawn
	static uint8 m_sTacticsOn;
protected:
	SSuitPoweredParams m_suitParams;
private:
};


#endif //__BOMB_LAUNCH_H__
