/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 15:06:2007   : Created by Denisz Polgar

*************************************************************************/
#include "StdAfx.h"
#include "../../C4.h"
#include "TacticalC4.h"
#include "Plant.h"

#include "Game.h"
#include "Actor.h"
#include "WeaponSystem.h"
#include "GameActions.h"
#include "GameRules.h"

uint8 CTacticalC4::m_sTacticsOn = 127;
uint8 CTacticalC4::m_sTacticsOff = 255;

//------------------------------------------------------------------------
CTacticalC4::CTacticalC4()
{
}


//------------------------------------------------------------------------
CTacticalC4::~CTacticalC4()
{
};


//------------------------------------------------------------------------
void CTacticalC4::OnAction(EntityId actorId, const ActionId& actionId, int activationMode, float value)
{
	CWeapon::OnAction(actorId, actionId, activationMode, value);
}

//------------------------------------------------------------------------
void CTacticalC4::PickUp(EntityId pickerId, bool sound, bool select/* =true */, bool keepHistory/* =true */)
{
	CWeapon::PickUp(pickerId, sound, select, keepHistory);
}

//------------------------------------------------------------------------
bool CTacticalC4::CanSelect() const
{
	bool canSelect = (CWeapon::CanSelect() && !OutOfAmmo(false));

	return canSelect;
};

//------------------------------------------------------------------------
void CTacticalC4::Select(bool select)
{
	if (select)
	{
		bool outOfAmmo = OutOfAmmo(false);
	
		if(outOfAmmo)
		{
			Select(false);
			CActor *pOwner=GetOwnerActor();
			if (!pOwner)
				return;

			EntityId fistsId = pOwner->GetInventory()?pOwner->GetInventory()->GetItemByClass(CItem::sFistsClass):0;
			if (fistsId)
				pOwner->SelectItem(fistsId,true);

			return;
		}
	}

	CWeapon::Select(select);
}

//------------------------------------------------------------------------
void CTacticalC4::Drop(float impulseScale, bool selectNext, bool byDeath)
{
	EntityId fistsId = 0;
	
	CActor *pOwner = GetOwnerActor();
	if(pOwner)
		fistsId = pOwner->GetInventory()?pOwner->GetInventory()->GetItemByClass(CItem::sFistsClass):0;

	CItem::Drop(impulseScale,selectNext,byDeath);

	if (fistsId)
		pOwner->SelectItem(fistsId,true);

}

void CTacticalC4::StartFire()
{
	if (CanFire(false, true))
		CWeapon::StartFire();
}

bool CTacticalC4::CanFire() const
{
	return CanFire(true, false);
}

bool CTacticalC4::CanFire(bool fullcheck, bool warn) const
{
	if (fullcheck && !CWeapon::CanFire())
		return false;

	CActor *pOwner=GetOwnerActor();
	if (!pOwner)
		return false;

	if (!pOwner->IsInHotZone())
	{
		if (warn)
			g_pGame->GetGameRules()->OnTextMessage(eTextMessageCenter, "@mp_CannotPlantExplosive");
		return false;
	}
	
	return true;
}
/*
//------------------------------------------------------------------------
IMPLEMENT_RMI(CTacticalC4, ClSetProjectileId2)
{
	IFireMode *pFireMode=GetFireMode(params.fmId);
	if (pFireMode)
		pFireMode->SetProjectileId(params.id);
	else
		return false;

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CTacticalC4, SvRequestTime2)
{
	IFireMode *pFireMode=GetFireMode(params.fmId);
	if (pFireMode && !stricmp(pFireMode->GetType(), "Plant"))
	{
		CPlant *pPlant=static_cast<CPlant *>(pFireMode);
		pPlant->SetTime(params.time);
	}
	else
		return false;

	return true;
}*/