/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: C4 Implementation for Tactical combat game mode

-------------------------------------------------------------------------
History:
- 15:06:2007   : Created by Denisz Polgar

*************************************************************************/
#ifndef __TacticalC4_H__
#define __TacticalC4_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IItemSystem.h>
#include "Weapon.h"


class CTacticalC4 :
	public CC4
{
public:
	CTacticalC4();
	virtual ~CTacticalC4();

	virtual void OnAction(EntityId actorId, const ActionId& actionId, int activationMode, float value);

	virtual void PickUp(EntityId pickerId, bool sound, bool select, bool keepHistory);
	virtual bool CanSelect() const;
	virtual void Select(bool select);
	virtual void GetMemoryStatistics(ICrySizer * s) { s->Add(*this); CWeapon::GetMemoryStatistics(s); }
	virtual void Drop(float impulseScale, bool selectNext/* =true */, bool byDeath/* =false */);

	virtual void StartFire();
	virtual bool CanFire() const;

	// SECURITY: Bullet spawn
	static uint8	m_sTacticsOn;
	static uint8	m_sTacticsOff;
protected:
	bool CanFire(bool fullcheck, bool warn) const;
};

#endif // __TacticalC4_H__